package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDisksResponse(disks: scala.Option[Iterable[Disk]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDisksResponse = {
    import GetDisksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDisksResponse.builder().optionallyWith(disks.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.disks).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDisksResponse.ReadOnly = GetDisksResponse.wrap(buildAwsValue())
}
object GetDisksResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDisksResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDisksResponse = GetDisksResponse(disksValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def disksValue: scala.Option[List[Disk.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def disks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Disk.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disks", disksValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse) extends GetDisksResponse.ReadOnly {
    override def disksValue: scala.Option[List[Disk.ReadOnly]] = scala.Option(impl.disks()).map(value => value.asScala.map { item => 
      Disk.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse): ReadOnly = new Wrapper(impl)
}