package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketBundlesRequest(includeInactive: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest = {
    import GetBucketBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest.builder().optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(_.includeInactive).build()
  }
  def asReadOnly: GetBucketBundlesRequest.ReadOnly = GetBucketBundlesRequest.wrap(buildAwsValue())
}
object GetBucketBundlesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketBundlesRequest = GetBucketBundlesRequest(includeInactiveValue.map(value => value))
    def includeInactiveValue: scala.Option[Boolean]
    def includeInactive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeInactive", includeInactiveValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest) extends GetBucketBundlesRequest.ReadOnly { override def includeInactiveValue: scala.Option[Boolean] = scala.Option(impl.includeInactive()).map(value => value: Boolean) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest): ReadOnly = new Wrapper(impl)
}