package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAlarmsResponse(alarms: scala.Option[Iterable[Alarm]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse = {
    import GetAlarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse.builder().optionallyWith(alarms.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.alarms).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetAlarmsResponse.ReadOnly = GetAlarmsResponse.wrap(buildAwsValue())
}
object GetAlarmsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAlarmsResponse = GetAlarmsResponse(alarmsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def alarmsValue: scala.Option[List[Alarm.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def alarms: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Alarm.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("alarms", alarmsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse) extends GetAlarmsResponse.ReadOnly {
    override def alarmsValue: scala.Option[List[Alarm.ReadOnly]] = scala.Option(impl.alarms()).map(value => value.asScala.map { item => 
      Alarm.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse): ReadOnly = new Wrapper(impl)
}