package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateKeyPairResponse(keyPair: scala.Option[KeyPair] = None, publicKeyBase64: scala.Option[primitives.Base64] = None, privateKeyBase64: scala.Option[primitives.Base64] = None, operation: scala.Option[Operation] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse = {
    import CreateKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse.builder().optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair).optionallyWith(publicKeyBase64.map(value => value: java.lang.String))(_.publicKeyBase64).optionallyWith(privateKeyBase64.map(value => value: java.lang.String))(_.privateKeyBase64).optionallyWith(operation.map(value => value.buildAwsValue()))(_.operation).build()
  }
  def asReadOnly: CreateKeyPairResponse.ReadOnly = CreateKeyPairResponse.wrap(buildAwsValue())
}
object CreateKeyPairResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateKeyPairResponse = CreateKeyPairResponse(keyPairValue.map(value => value.editable), publicKeyBase64Value.map(value => value), privateKeyBase64Value.map(value => value), operationValue.map(value => value.editable))
    def keyPairValue: scala.Option[KeyPair.ReadOnly]
    def publicKeyBase64Value: scala.Option[primitives.Base64]
    def privateKeyBase64Value: scala.Option[primitives.Base64]
    def operationValue: scala.Option[Operation.ReadOnly]
    def keyPair: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KeyPair.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPair", keyPairValue)
    def publicKeyBase64: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Base64] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64Value)
    def privateKeyBase64: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Base64] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64Value)
    def operation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Operation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse) extends CreateKeyPairResponse.ReadOnly {
    override def keyPairValue: scala.Option[KeyPair.ReadOnly] = scala.Option(impl.keyPair()).map(value => KeyPair.wrap(value))
    override def publicKeyBase64Value: scala.Option[primitives.Base64] = scala.Option(impl.publicKeyBase64()).map(value => value: primitives.Base64)
    override def privateKeyBase64Value: scala.Option[primitives.Base64] = scala.Option(impl.privateKeyBase64()).map(value => value: primitives.Base64)
    override def operationValue: scala.Option[Operation.ReadOnly] = scala.Option(impl.operation()).map(value => Operation.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse): ReadOnly = new Wrapper(impl)
}