package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDistributionRequest(distributionName: primitives.ResourceName, origin: InputOrigin, defaultCacheBehavior: CacheBehavior, cacheBehaviorSettings: scala.Option[CacheSettings] = None, cacheBehaviors: scala.Option[Iterable[CacheBehaviorPerPath]] = None, bundleId: String, ipAddressType: scala.Option[IpAddressType] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest = {
    import CreateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest.builder().distributionName(distributionName: java.lang.String).origin(origin.buildAwsValue()).defaultCacheBehavior(defaultCacheBehavior.buildAwsValue()).optionallyWith(cacheBehaviorSettings.map(value => value.buildAwsValue()))(_.cacheBehaviorSettings).optionallyWith(cacheBehaviors.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cacheBehaviors).bundleId(bundleId: java.lang.String).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateDistributionRequest.ReadOnly = CreateDistributionRequest.wrap(buildAwsValue())
}
object CreateDistributionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDistributionRequest = CreateDistributionRequest(distributionNameValue, originValue.editable, defaultCacheBehaviorValue.editable, cacheBehaviorSettingsValue.map(value => value.editable), cacheBehaviorsValue.map(value => value.map { item => 
      item.editable
    }), bundleIdValue, ipAddressTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def distributionNameValue: primitives.ResourceName
    def originValue: InputOrigin.ReadOnly
    def defaultCacheBehaviorValue: CacheBehavior.ReadOnly
    def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly]
    def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]]
    def bundleIdValue: String
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def distributionName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(distributionNameValue)
    def origin: ZIO[Any, Nothing, InputOrigin.ReadOnly] = ZIO.succeed(originValue)
    def defaultCacheBehavior: ZIO[Any, Nothing, CacheBehavior.ReadOnly] = ZIO.succeed(defaultCacheBehaviorValue)
    def cacheBehaviorSettings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CacheSettings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettingsValue)
    def cacheBehaviors: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CacheBehaviorPerPath.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def bundleId: ZIO[Any, Nothing, String] = ZIO.succeed(bundleIdValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest) extends CreateDistributionRequest.ReadOnly {
    override def distributionNameValue: primitives.ResourceName = impl.distributionName(): primitives.ResourceName
    override def originValue: InputOrigin.ReadOnly = InputOrigin.wrap(impl.origin())
    override def defaultCacheBehaviorValue: CacheBehavior.ReadOnly = CacheBehavior.wrap(impl.defaultCacheBehavior())
    override def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly] = scala.Option(impl.cacheBehaviorSettings()).map(value => CacheSettings.wrap(value))
    override def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]] = scala.Option(impl.cacheBehaviors()).map(value => value.asScala.map { item => 
      CacheBehaviorPerPath.wrap(item)
    }.toList)
    override def bundleIdValue: String = impl.bundleId(): String
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest): ReadOnly = new Wrapper(impl)
}