package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateCertificateRequest(certificateName: primitives.CertificateName, domainName: primitives.DomainName, subjectAlternativeNames: scala.Option[Iterable[primitives.DomainName]] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest = {
    import CreateCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest.builder().certificateName(certificateName: java.lang.String).domainName(domainName: java.lang.String).optionallyWith(subjectAlternativeNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.subjectAlternativeNames).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateCertificateRequest.ReadOnly = CreateCertificateRequest.wrap(buildAwsValue())
}
object CreateCertificateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateCertificateRequest = CreateCertificateRequest(certificateNameValue, domainNameValue, subjectAlternativeNamesValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def certificateNameValue: primitives.CertificateName
    def domainNameValue: primitives.DomainName
    def subjectAlternativeNamesValue: scala.Option[List[primitives.DomainName]]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def certificateName: ZIO[Any, Nothing, primitives.CertificateName] = ZIO.succeed(certificateNameValue)
    def domainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(domainNameValue)
    def subjectAlternativeNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.DomainName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subjectAlternativeNames", subjectAlternativeNamesValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest) extends CreateCertificateRequest.ReadOnly {
    override def certificateNameValue: primitives.CertificateName = impl.certificateName(): primitives.CertificateName
    override def domainNameValue: primitives.DomainName = impl.domainName(): primitives.DomainName
    override def subjectAlternativeNamesValue: scala.Option[List[primitives.DomainName]] = scala.Option(impl.subjectAlternativeNames()).map(value => value.asScala.map { item => 
      item: primitives.DomainName
    }.toList)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest): ReadOnly = new Wrapper(impl)
}