package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateBucketAccessKeyResponse(accessKey: scala.Option[AccessKey] = None, operations: scala.Option[Iterable[Operation]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse = {
    import CreateBucketAccessKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse.builder().optionallyWith(accessKey.map(value => value.buildAwsValue()))(_.accessKey).optionallyWith(operations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.operations).build()
  }
  def asReadOnly: CreateBucketAccessKeyResponse.ReadOnly = CreateBucketAccessKeyResponse.wrap(buildAwsValue())
}
object CreateBucketAccessKeyResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateBucketAccessKeyResponse = CreateBucketAccessKeyResponse(accessKeyValue.map(value => value.editable), operationsValue.map(value => value.map { item => 
      item.editable
    }))
    def accessKeyValue: scala.Option[AccessKey.ReadOnly]
    def operationsValue: scala.Option[List[Operation.ReadOnly]]
    def accessKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccessKey.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessKey", accessKeyValue)
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Operation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse) extends CreateBucketAccessKeyResponse.ReadOnly {
    override def accessKeyValue: scala.Option[AccessKey.ReadOnly] = scala.Option(impl.accessKey()).map(value => AccessKey.wrap(value))
    override def operationsValue: scala.Option[List[Operation.ReadOnly]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      Operation.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse): ReadOnly = new Wrapper(impl)
}