package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloudFormationStackRecordSourceInfo(resourceType: scala.Option[CloudFormationStackRecordSourceType] = None, name: scala.Option[primitives.NonEmptyString] = None, arn: scala.Option[primitives.NonEmptyString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo = {
    import CloudFormationStackRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo.builder().optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).build()
  }
  def asReadOnly: CloudFormationStackRecordSourceInfo.ReadOnly = CloudFormationStackRecordSourceInfo.wrap(buildAwsValue())
}
object CloudFormationStackRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloudFormationStackRecordSourceInfo = CloudFormationStackRecordSourceInfo(resourceTypeValue.map(value => value), nameValue.map(value => value), arnValue.map(value => value))
    def resourceTypeValue: scala.Option[CloudFormationStackRecordSourceType]
    def nameValue: scala.Option[primitives.NonEmptyString]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CloudFormationStackRecordSourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo) extends CloudFormationStackRecordSourceInfo.ReadOnly {
    override def resourceTypeValue: scala.Option[CloudFormationStackRecordSourceType] = scala.Option(impl.resourceType()).map(value => CloudFormationStackRecordSourceType.wrap(value))
    override def nameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.name()).map(value => value: primitives.NonEmptyString)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo): ReadOnly = new Wrapper(impl)
}