package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CertificateSummary(certificateArn: scala.Option[primitives.NonEmptyString] = None, certificateName: scala.Option[primitives.CertificateName] = None, domainName: scala.Option[primitives.DomainName] = None, certificateDetail: scala.Option[Certificate] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CertificateSummary.builder().optionallyWith(certificateArn.map(value => value: java.lang.String))(_.certificateArn).optionallyWith(certificateName.map(value => value: java.lang.String))(_.certificateName).optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(certificateDetail.map(value => value.buildAwsValue()))(_.certificateDetail).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CertificateSummary.ReadOnly = CertificateSummary.wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CertificateSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CertificateSummary = CertificateSummary(certificateArnValue.map(value => value), certificateNameValue.map(value => value), domainNameValue.map(value => value), certificateDetailValue.map(value => value.editable), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def certificateArnValue: scala.Option[primitives.NonEmptyString]
    def certificateNameValue: scala.Option[primitives.CertificateName]
    def domainNameValue: scala.Option[primitives.DomainName]
    def certificateDetailValue: scala.Option[Certificate.ReadOnly]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def certificateArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateArn", certificateArnValue)
    def certificateName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.CertificateName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def certificateDetail: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Certificate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateDetail", certificateDetailValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary) extends CertificateSummary.ReadOnly {
    override def certificateArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.certificateArn()).map(value => value: primitives.NonEmptyString)
    override def certificateNameValue: scala.Option[primitives.CertificateName] = scala.Option(impl.certificateName()).map(value => value: primitives.CertificateName)
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
    override def certificateDetailValue: scala.Option[Certificate.ReadOnly] = scala.Option(impl.certificateDetail()).map(value => Certificate.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary): ReadOnly = new Wrapper(impl)
}