package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBucketBundleRequest(bucketName: primitives.BucketName, bundleId: primitives.NonEmptyString) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest = {
    import UpdateBucketBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest.builder().bucketName(bucketName: java.lang.String).bundleId(bundleId: java.lang.String).build()
  }
  def asReadOnly: UpdateBucketBundleRequest.ReadOnly = UpdateBucketBundleRequest.wrap(buildAwsValue())
}
object UpdateBucketBundleRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBucketBundleRequest = UpdateBucketBundleRequest(bucketNameValue, bundleIdValue)
    def bucketNameValue: primitives.BucketName
    def bundleIdValue: primitives.NonEmptyString
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def bundleId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(bundleIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest) extends UpdateBucketBundleRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def bundleIdValue: primitives.NonEmptyString = impl.bundleId(): primitives.NonEmptyString
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest): ReadOnly = new Wrapper(impl)
}