package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseSnapshot(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, engine: scala.Option[primitives.NonEmptyString] = None, engineVersion: scala.Option[primitives.NonEmptyString] = None, sizeInGb: scala.Option[primitives.Integer] = None, state: scala.Option[primitives.NonEmptyString] = None, fromRelationalDatabaseName: scala.Option[primitives.NonEmptyString] = None, fromRelationalDatabaseArn: scala.Option[primitives.NonEmptyString] = None, fromRelationalDatabaseBundleId: scala.Option[String] = None, fromRelationalDatabaseBlueprintId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot = {
    import RelationalDatabaseSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).optionallyWith(state.map(value => value: java.lang.String))(_.state).optionallyWith(fromRelationalDatabaseName.map(value => value: java.lang.String))(_.fromRelationalDatabaseName).optionallyWith(fromRelationalDatabaseArn.map(value => value: java.lang.String))(_.fromRelationalDatabaseArn).optionallyWith(fromRelationalDatabaseBundleId.map(value => value: java.lang.String))(_.fromRelationalDatabaseBundleId).optionallyWith(fromRelationalDatabaseBlueprintId.map(value => value: java.lang.String))(_.fromRelationalDatabaseBlueprintId).build()
  }
  def asReadOnly: RelationalDatabaseSnapshot.ReadOnly = RelationalDatabaseSnapshot.wrap(buildAwsValue())
}
object RelationalDatabaseSnapshot {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseSnapshot = RelationalDatabaseSnapshot(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), engineValue.map(value => value), engineVersionValue.map(value => value), sizeInGbValue.map(value => value), stateValue.map(value => value), fromRelationalDatabaseNameValue.map(value => value), fromRelationalDatabaseArnValue.map(value => value), fromRelationalDatabaseBundleIdValue.map(value => value), fromRelationalDatabaseBlueprintIdValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def engineValue: scala.Option[primitives.NonEmptyString]
    def engineVersionValue: scala.Option[primitives.NonEmptyString]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def stateValue: scala.Option[primitives.NonEmptyString]
    def fromRelationalDatabaseNameValue: scala.Option[primitives.NonEmptyString]
    def fromRelationalDatabaseArnValue: scala.Option[primitives.NonEmptyString]
    def fromRelationalDatabaseBundleIdValue: scala.Option[String]
    def fromRelationalDatabaseBlueprintIdValue: scala.Option[String]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def fromRelationalDatabaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromRelationalDatabaseName", fromRelationalDatabaseNameValue)
    def fromRelationalDatabaseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromRelationalDatabaseArn", fromRelationalDatabaseArnValue)
    def fromRelationalDatabaseBundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromRelationalDatabaseBundleId", fromRelationalDatabaseBundleIdValue)
    def fromRelationalDatabaseBlueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromRelationalDatabaseBlueprintId", fromRelationalDatabaseBlueprintIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot) extends RelationalDatabaseSnapshot.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def engineValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.engine()).map(value => value: primitives.NonEmptyString)
    override def engineVersionValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.engineVersion()).map(value => value: primitives.NonEmptyString)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
    override def stateValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.state()).map(value => value: primitives.NonEmptyString)
    override def fromRelationalDatabaseNameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromRelationalDatabaseName()).map(value => value: primitives.NonEmptyString)
    override def fromRelationalDatabaseArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromRelationalDatabaseArn()).map(value => value: primitives.NonEmptyString)
    override def fromRelationalDatabaseBundleIdValue: scala.Option[String] = scala.Option(impl.fromRelationalDatabaseBundleId()).map(value => value: String)
    override def fromRelationalDatabaseBlueprintIdValue: scala.Option[String] = scala.Option(impl.fromRelationalDatabaseBlueprintId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot): ReadOnly = new Wrapper(impl)
}