package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RegionName { def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName }
object RegionName {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.RegionName): RegionName = value match {
    case software.amazon.awssdk.services.lightsail.model.RegionName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_2 =>
      val r = `eu-west-2`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_3 =>
      val r = `eu-west-3`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.CA_CENTRAL_1 =>
      val r = `ca-central-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTH_1 =>
      val r = `ap-south-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.AP_NORTHEAST_2 =>
      val r = `ap-northeast-2`
      r
    case software.amazon.awssdk.services.lightsail.model.RegionName.EU_NORTH_1 =>
      val r = `eu-north-1`
      r
  }
  case object unknownToSdkVersion extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.UNKNOWN_TO_SDK_VERSION }
  case object `us-east-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.US_EAST_1 }
  case object `us-east-2` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.US_EAST_2 }
  case object `us-west-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.US_WEST_1 }
  case object `us-west-2` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.US_WEST_2 }
  case object `eu-west-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_1 }
  case object `eu-west-2` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_2 }
  case object `eu-west-3` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.EU_WEST_3 }
  case object `eu-central-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.EU_CENTRAL_1 }
  case object `ca-central-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.CA_CENTRAL_1 }
  case object `ap-south-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTH_1 }
  case object `ap-southeast-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTHEAST_1 }
  case object `ap-southeast-2` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.AP_SOUTHEAST_2 }
  case object `ap-northeast-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.AP_NORTHEAST_1 }
  case object `ap-northeast-2` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.AP_NORTHEAST_2 }
  case object `eu-north-1` extends RegionName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RegionName = software.amazon.awssdk.services.lightsail.model.RegionName.EU_NORTH_1 }
}