package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait IpAddressType { def unwrap: software.amazon.awssdk.services.lightsail.model.IpAddressType }
object IpAddressType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.IpAddressType): IpAddressType = value match {
    case software.amazon.awssdk.services.lightsail.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.IpAddressType.DUALSTACK =>
      val r = dualstack
      r
    case software.amazon.awssdk.services.lightsail.model.IpAddressType.IPV4 =>
      val r = ipv4
      r
  }
  case object unknownToSdkVersion extends IpAddressType { override def unwrap: software.amazon.awssdk.services.lightsail.model.IpAddressType = software.amazon.awssdk.services.lightsail.model.IpAddressType.UNKNOWN_TO_SDK_VERSION }
  case object dualstack extends IpAddressType { override def unwrap: software.amazon.awssdk.services.lightsail.model.IpAddressType = software.amazon.awssdk.services.lightsail.model.IpAddressType.DUALSTACK }
  case object ipv4 extends IpAddressType { override def unwrap: software.amazon.awssdk.services.lightsail.model.IpAddressType = software.amazon.awssdk.services.lightsail.model.IpAddressType.IPV4 }
}