package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstancePortState(fromPort: scala.Option[primitives.Port] = None, toPort: scala.Option[primitives.Port] = None, protocol: scala.Option[NetworkProtocol] = None, state: scala.Option[PortState] = None, cidrs: scala.Option[Iterable[String]] = None, ipv6Cidrs: scala.Option[Iterable[String]] = None, cidrListAliases: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstancePortState = {
    import InstancePortState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortState.builder().optionallyWith(fromPort.map(value => value: java.lang.Integer))(_.fromPort).optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(cidrs.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.cidrs).optionallyWith(ipv6Cidrs.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.ipv6Cidrs).optionallyWith(cidrListAliases.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.cidrListAliases).build()
  }
  def asReadOnly: InstancePortState.ReadOnly = InstancePortState.wrap(buildAwsValue())
}
object InstancePortState {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstancePortState] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstancePortState = InstancePortState(fromPortValue.map(value => value), toPortValue.map(value => value), protocolValue.map(value => value), stateValue.map(value => value), cidrsValue.map(value => value), ipv6CidrsValue.map(value => value), cidrListAliasesValue.map(value => value))
    def fromPortValue: scala.Option[primitives.Port]
    def toPortValue: scala.Option[primitives.Port]
    def protocolValue: scala.Option[NetworkProtocol]
    def stateValue: scala.Option[PortState]
    def cidrsValue: scala.Option[List[String]]
    def ipv6CidrsValue: scala.Option[List[String]]
    def cidrListAliasesValue: scala.Option[List[String]]
    def fromPort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Port] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromPort", fromPortValue)
    def toPort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Port] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("toPort", toPortValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NetworkProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PortState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def cidrs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrs", cidrsValue)
    def ipv6Cidrs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipv6Cidrs", ipv6CidrsValue)
    def cidrListAliases: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrListAliases", cidrListAliasesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstancePortState) extends InstancePortState.ReadOnly {
    override def fromPortValue: scala.Option[primitives.Port] = scala.Option(impl.fromPort()).map(value => value: primitives.Port)
    override def toPortValue: scala.Option[primitives.Port] = scala.Option(impl.toPort()).map(value => value: primitives.Port)
    override def protocolValue: scala.Option[NetworkProtocol] = scala.Option(impl.protocol()).map(value => NetworkProtocol.wrap(value))
    override def stateValue: scala.Option[PortState] = scala.Option(impl.state()).map(value => PortState.wrap(value))
    override def cidrsValue: scala.Option[List[String]] = scala.Option(impl.cidrs()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def ipv6CidrsValue: scala.Option[List[String]] = scala.Option(impl.ipv6Cidrs()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def cidrListAliasesValue: scala.Option[List[String]] = scala.Option(impl.cidrListAliases()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstancePortState): ReadOnly = new Wrapper(impl)
}