package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseLogEventsResponse(resourceLogEvents: scala.Option[Iterable[LogEvent]] = None, nextBackwardToken: scala.Option[String] = None, nextForwardToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse = {
    import GetRelationalDatabaseLogEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse.builder().optionallyWith(resourceLogEvents.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.resourceLogEvents).optionallyWith(nextBackwardToken.map(value => value: java.lang.String))(_.nextBackwardToken).optionallyWith(nextForwardToken.map(value => value: java.lang.String))(_.nextForwardToken).build()
  }
  def asReadOnly: GetRelationalDatabaseLogEventsResponse.ReadOnly = GetRelationalDatabaseLogEventsResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseLogEventsResponse = GetRelationalDatabaseLogEventsResponse(resourceLogEventsValue.map(value => value.map { item => 
      item.editable
    }), nextBackwardTokenValue.map(value => value), nextForwardTokenValue.map(value => value))
    def resourceLogEventsValue: scala.Option[List[LogEvent.ReadOnly]]
    def nextBackwardTokenValue: scala.Option[String]
    def nextForwardTokenValue: scala.Option[String]
    def resourceLogEvents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LogEvent.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceLogEvents", resourceLogEventsValue)
    def nextBackwardToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextBackwardToken", nextBackwardTokenValue)
    def nextForwardToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextForwardToken", nextForwardTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse) extends GetRelationalDatabaseLogEventsResponse.ReadOnly {
    override def resourceLogEventsValue: scala.Option[List[LogEvent.ReadOnly]] = scala.Option(impl.resourceLogEvents()).map(value => value.asScala.map { item => 
      LogEvent.wrap(item)
    }.toList)
    override def nextBackwardTokenValue: scala.Option[String] = scala.Option(impl.nextBackwardToken()).map(value => value: String)
    override def nextForwardTokenValue: scala.Option[String] = scala.Option(impl.nextForwardToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse): ReadOnly = new Wrapper(impl)
}