package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetKeyPairsResponse(keyPairs: scala.Option[Iterable[KeyPair]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse = {
    import GetKeyPairsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse.builder().optionallyWith(keyPairs.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.keyPairs).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetKeyPairsResponse.ReadOnly = GetKeyPairsResponse.wrap(buildAwsValue())
}
object GetKeyPairsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetKeyPairsResponse = GetKeyPairsResponse(keyPairsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def keyPairsValue: scala.Option[List[KeyPair.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def keyPairs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[KeyPair.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPairs", keyPairsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse) extends GetKeyPairsResponse.ReadOnly {
    override def keyPairsValue: scala.Option[List[KeyPair.ReadOnly]] = scala.Option(impl.keyPairs()).map(value => value.asScala.map { item => 
      KeyPair.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse): ReadOnly = new Wrapper(impl)
}