package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceResponse(instance: scala.Option[Instance] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceResponse = {
    import GetInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceResponse.builder().optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance).build()
  }
  def asReadOnly: GetInstanceResponse.ReadOnly = GetInstanceResponse.wrap(buildAwsValue())
}
object GetInstanceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceResponse = GetInstanceResponse(instanceValue.map(value => value.editable))
    def instanceValue: scala.Option[Instance.ReadOnly]
    def instance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Instance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instance", instanceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse) extends GetInstanceResponse.ReadOnly { override def instanceValue: scala.Option[Instance.ReadOnly] = scala.Option(impl.instance()).map(value => Instance.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse): ReadOnly = new Wrapper(impl)
}