package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDiskSnapshotsResponse(diskSnapshots: scala.Option[Iterable[DiskSnapshot]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse = {
    import GetDiskSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse.builder().optionallyWith(diskSnapshots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.diskSnapshots).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDiskSnapshotsResponse.ReadOnly = GetDiskSnapshotsResponse.wrap(buildAwsValue())
}
object GetDiskSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDiskSnapshotsResponse = GetDiskSnapshotsResponse(diskSnapshotsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def diskSnapshotsValue: scala.Option[List[DiskSnapshot.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def diskSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DiskSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSnapshots", diskSnapshotsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse) extends GetDiskSnapshotsResponse.ReadOnly {
    override def diskSnapshotsValue: scala.Option[List[DiskSnapshot.ReadOnly]] = scala.Option(impl.diskSnapshots()).map(value => value.asScala.map { item => 
      DiskSnapshot.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse): ReadOnly = new Wrapper(impl)
}