package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketsRequest(bucketName: scala.Option[primitives.BucketName] = None, pageToken: scala.Option[String] = None, includeConnectedResources: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketsRequest = {
    import GetBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsRequest.builder().optionallyWith(bucketName.map(value => value: java.lang.String))(_.bucketName).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).optionallyWith(includeConnectedResources.map(value => value: java.lang.Boolean))(_.includeConnectedResources).build()
  }
  def asReadOnly: GetBucketsRequest.ReadOnly = GetBucketsRequest.wrap(buildAwsValue())
}
object GetBucketsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketsRequest = GetBucketsRequest(bucketNameValue.map(value => value), pageTokenValue.map(value => value), includeConnectedResourcesValue.map(value => value))
    def bucketNameValue: scala.Option[primitives.BucketName]
    def pageTokenValue: scala.Option[String]
    def includeConnectedResourcesValue: scala.Option[Boolean]
    def bucketName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BucketName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bucketName", bucketNameValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
    def includeConnectedResources: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeConnectedResources", includeConnectedResourcesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest) extends GetBucketsRequest.ReadOnly {
    override def bucketNameValue: scala.Option[primitives.BucketName] = scala.Option(impl.bucketName()).map(value => value: primitives.BucketName)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
    override def includeConnectedResourcesValue: scala.Option[Boolean] = scala.Option(impl.includeConnectedResources()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest): ReadOnly = new Wrapper(impl)
}