package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiskMap(originalDiskPath: scala.Option[primitives.NonEmptyString] = None, newDiskName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DiskMap = {
    import DiskMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskMap.builder().optionallyWith(originalDiskPath.map(value => value: java.lang.String))(_.originalDiskPath).optionallyWith(newDiskName.map(value => value: java.lang.String))(_.newDiskName).build()
  }
  def asReadOnly: DiskMap.ReadOnly = DiskMap.wrap(buildAwsValue())
}
object DiskMap {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskMap] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiskMap = DiskMap(originalDiskPathValue.map(value => value), newDiskNameValue.map(value => value))
    def originalDiskPathValue: scala.Option[primitives.NonEmptyString]
    def newDiskNameValue: scala.Option[primitives.ResourceName]
    def originalDiskPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("originalDiskPath", originalDiskPathValue)
    def newDiskName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDiskName", newDiskNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DiskMap) extends DiskMap.ReadOnly {
    override def originalDiskPathValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.originalDiskPath()).map(value => value: primitives.NonEmptyString)
    override def newDiskNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.newDiskName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DiskMap): ReadOnly = new Wrapper(impl)
}