package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DisableAddOnRequest(addOnType: AddOnType, resourceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest = {
    import DisableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest.builder().addOnType(addOnType.unwrap).resourceName(resourceName: java.lang.String).build()
  }
  def asReadOnly: DisableAddOnRequest.ReadOnly = DisableAddOnRequest.wrap(buildAwsValue())
}
object DisableAddOnRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DisableAddOnRequest = DisableAddOnRequest(addOnTypeValue, resourceNameValue)
    def addOnTypeValue: AddOnType
    def resourceNameValue: primitives.ResourceName
    def addOnType: ZIO[Any, Nothing, AddOnType] = ZIO.succeed(addOnTypeValue)
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest) extends DisableAddOnRequest.ReadOnly {
    override def addOnTypeValue: AddOnType = AddOnType.wrap(impl.addOnType())
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest): ReadOnly = new Wrapper(impl)
}