package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateBucketAccessKeyRequest(bucketName: primitives.BucketName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest = {
    import CreateBucketAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest.builder().bucketName(bucketName: java.lang.String).build()
  }
  def asReadOnly: CreateBucketAccessKeyRequest.ReadOnly = CreateBucketAccessKeyRequest.wrap(buildAwsValue())
}
object CreateBucketAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateBucketAccessKeyRequest = CreateBucketAccessKeyRequest(bucketNameValue)
    def bucketNameValue: primitives.BucketName
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest) extends CreateBucketAccessKeyRequest.ReadOnly { override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest): ReadOnly = new Wrapper(impl)
}