package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.lightsail.{ LightsailAsyncClient, LightsailAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object lightsail {
  type Lightsail = Has[Lightsail.Service]
  object Lightsail {
    trait Service extends AspectSupport[Service] {
      val api: LightsailAsyncClient
      def putInstancePublicPorts(request: model.PutInstancePublicPortsRequest): IO[AwsError, model.PutInstancePublicPortsResponse.ReadOnly]
      def resetDistributionCache(request: model.ResetDistributionCacheRequest): IO[AwsError, model.ResetDistributionCacheResponse.ReadOnly]
      def getRelationalDatabaseSnapshot(request: model.GetRelationalDatabaseSnapshotRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotResponse.ReadOnly]
      def getKeyPair(request: model.GetKeyPairRequest): IO[AwsError, model.GetKeyPairResponse.ReadOnly]
      def getInstanceAccessDetails(request: model.GetInstanceAccessDetailsRequest): IO[AwsError, model.GetInstanceAccessDetailsResponse.ReadOnly]
      def deleteLoadBalancerTlsCertificate(request: model.DeleteLoadBalancerTlsCertificateRequest): IO[AwsError, model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly]
      def createDiskSnapshot(request: model.CreateDiskSnapshotRequest): IO[AwsError, model.CreateDiskSnapshotResponse.ReadOnly]
      def deleteRelationalDatabase(request: model.DeleteRelationalDatabaseRequest): IO[AwsError, model.DeleteRelationalDatabaseResponse.ReadOnly]
      def releaseStaticIp(request: model.ReleaseStaticIpRequest): IO[AwsError, model.ReleaseStaticIpResponse.ReadOnly]
      def updateLoadBalancerAttribute(request: model.UpdateLoadBalancerAttributeRequest): IO[AwsError, model.UpdateLoadBalancerAttributeResponse.ReadOnly]
      def testAlarm(request: model.TestAlarmRequest): IO[AwsError, model.TestAlarmResponse.ReadOnly]
      def closeInstancePublicPorts(request: model.CloseInstancePublicPortsRequest): IO[AwsError, model.CloseInstancePublicPortsResponse.ReadOnly]
      def deleteContactMethod(request: model.DeleteContactMethodRequest): IO[AwsError, model.DeleteContactMethodResponse.ReadOnly]
      def deleteDiskSnapshot(request: model.DeleteDiskSnapshotRequest): IO[AwsError, model.DeleteDiskSnapshotResponse.ReadOnly]
      def putAlarm(request: model.PutAlarmRequest): IO[AwsError, model.PutAlarmResponse.ReadOnly]
      def getInstances(request: model.GetInstancesRequest): IO[AwsError, model.GetInstancesResponse.ReadOnly]
      def createCertificate(request: model.CreateCertificateRequest): IO[AwsError, model.CreateCertificateResponse.ReadOnly]
      def getRelationalDatabaseLogEvents(request: model.GetRelationalDatabaseLogEventsRequest): IO[AwsError, model.GetRelationalDatabaseLogEventsResponse.ReadOnly]
      def deleteKnownHostKeys(request: model.DeleteKnownHostKeysRequest): IO[AwsError, model.DeleteKnownHostKeysResponse.ReadOnly]
      def rebootRelationalDatabase(request: model.RebootRelationalDatabaseRequest): IO[AwsError, model.RebootRelationalDatabaseResponse.ReadOnly]
      def createCloudFormationStack(request: model.CreateCloudFormationStackRequest): IO[AwsError, model.CreateCloudFormationStackResponse.ReadOnly]
      def detachDisk(request: model.DetachDiskRequest): IO[AwsError, model.DetachDiskResponse.ReadOnly]
      def allocateStaticIp(request: model.AllocateStaticIpRequest): IO[AwsError, model.AllocateStaticIpResponse.ReadOnly]
      def getRelationalDatabaseEvents(request: model.GetRelationalDatabaseEventsRequest): IO[AwsError, model.GetRelationalDatabaseEventsResponse.ReadOnly]
      def getOperations(request: model.GetOperationsRequest): IO[AwsError, model.GetOperationsResponse.ReadOnly]
      def getInstanceState(request: model.GetInstanceStateRequest): IO[AwsError, model.GetInstanceStateResponse.ReadOnly]
      def getDomains(request: model.GetDomainsRequest): IO[AwsError, model.GetDomainsResponse.ReadOnly]
      def getLoadBalancers(request: model.GetLoadBalancersRequest): IO[AwsError, model.GetLoadBalancersResponse.ReadOnly]
      def getContainerServices(request: model.GetContainerServicesRequest): IO[AwsError, model.GetContainerServicesResponse.ReadOnly]
      def getLoadBalancerTlsCertificates(request: model.GetLoadBalancerTlsCertificatesRequest): IO[AwsError, model.GetLoadBalancerTlsCertificatesResponse.ReadOnly]
      def createRelationalDatabaseFromSnapshot(request: model.CreateRelationalDatabaseFromSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly]
      def getInstanceSnapshot(request: model.GetInstanceSnapshotRequest): IO[AwsError, model.GetInstanceSnapshotResponse.ReadOnly]
      def deleteContainerService(request: model.DeleteContainerServiceRequest): IO[AwsError, model.DeleteContainerServiceResponse.ReadOnly]
      def getContainerAPIMetadata(request: model.GetContainerApiMetadataRequest): IO[AwsError, model.GetContainerApiMetadataResponse.ReadOnly]
      def getDiskSnapshot(request: model.GetDiskSnapshotRequest): IO[AwsError, model.GetDiskSnapshotResponse.ReadOnly]
      def detachStaticIp(request: model.DetachStaticIpRequest): IO[AwsError, model.DetachStaticIpResponse.ReadOnly]
      def createDisk(request: model.CreateDiskRequest): IO[AwsError, model.CreateDiskResponse.ReadOnly]
      def getContainerImages(request: model.GetContainerImagesRequest): IO[AwsError, model.GetContainerImagesResponse.ReadOnly]
      def createDomainEntry(request: model.CreateDomainEntryRequest): IO[AwsError, model.CreateDomainEntryResponse.ReadOnly]
      def sendContactMethodVerification(request: model.SendContactMethodVerificationRequest): IO[AwsError, model.SendContactMethodVerificationResponse.ReadOnly]
      def getDomain(request: model.GetDomainRequest): IO[AwsError, model.GetDomainResponse.ReadOnly]
      def deleteInstance(request: model.DeleteInstanceRequest): IO[AwsError, model.DeleteInstanceResponse.ReadOnly]
      def copySnapshot(request: model.CopySnapshotRequest): IO[AwsError, model.CopySnapshotResponse.ReadOnly]
      def getContactMethods(request: model.GetContactMethodsRequest): IO[AwsError, model.GetContactMethodsResponse.ReadOnly]
      def getRelationalDatabaseBundles(request: model.GetRelationalDatabaseBundlesRequest): IO[AwsError, model.GetRelationalDatabaseBundlesResponse.ReadOnly]
      def detachInstancesFromLoadBalancer(request: model.DetachInstancesFromLoadBalancerRequest): IO[AwsError, model.DetachInstancesFromLoadBalancerResponse.ReadOnly]
      def openInstancePublicPorts(request: model.OpenInstancePublicPortsRequest): IO[AwsError, model.OpenInstancePublicPortsResponse.ReadOnly]
      def getInstanceMetricData(request: model.GetInstanceMetricDataRequest): IO[AwsError, model.GetInstanceMetricDataResponse.ReadOnly]
      def deleteRelationalDatabaseSnapshot(request: model.DeleteRelationalDatabaseSnapshotRequest): IO[AwsError, model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly]
      def attachInstancesToLoadBalancer(request: model.AttachInstancesToLoadBalancerRequest): IO[AwsError, model.AttachInstancesToLoadBalancerResponse.ReadOnly]
      def getDistributionBundles(request: model.GetDistributionBundlesRequest): IO[AwsError, model.GetDistributionBundlesResponse.ReadOnly]
      def getRelationalDatabaseParameters(request: model.GetRelationalDatabaseParametersRequest): IO[AwsError, model.GetRelationalDatabaseParametersResponse.ReadOnly]
      def getAlarms(request: model.GetAlarmsRequest): IO[AwsError, model.GetAlarmsResponse.ReadOnly]
      def deleteLoadBalancer(request: model.DeleteLoadBalancerRequest): IO[AwsError, model.DeleteLoadBalancerResponse.ReadOnly]
      def getInstanceSnapshots(request: model.GetInstanceSnapshotsRequest): IO[AwsError, model.GetInstanceSnapshotsResponse.ReadOnly]
      def stopRelationalDatabase(request: model.StopRelationalDatabaseRequest): IO[AwsError, model.StopRelationalDatabaseResponse.ReadOnly]
      def getLoadBalancerMetricData(request: model.GetLoadBalancerMetricDataRequest): IO[AwsError, model.GetLoadBalancerMetricDataResponse.ReadOnly]
      def attachCertificateToDistribution(request: model.AttachCertificateToDistributionRequest): IO[AwsError, model.AttachCertificateToDistributionResponse.ReadOnly]
      def deleteCertificate(request: model.DeleteCertificateRequest): IO[AwsError, model.DeleteCertificateResponse.ReadOnly]
      def getInstance(request: model.GetInstanceRequest): IO[AwsError, model.GetInstanceResponse.ReadOnly]
      def getDistributions(request: model.GetDistributionsRequest): IO[AwsError, model.GetDistributionsResponse.ReadOnly]
      def getRelationalDatabases(request: model.GetRelationalDatabasesRequest): IO[AwsError, model.GetRelationalDatabasesResponse.ReadOnly]
      def attachLoadBalancerTlsCertificate(request: model.AttachLoadBalancerTlsCertificateRequest): IO[AwsError, model.AttachLoadBalancerTlsCertificateResponse.ReadOnly]
      def getOperationsForResource(request: model.GetOperationsForResourceRequest): IO[AwsError, model.GetOperationsForResourceResponse.ReadOnly]
      def createDiskFromSnapshot(request: model.CreateDiskFromSnapshotRequest): IO[AwsError, model.CreateDiskFromSnapshotResponse.ReadOnly]
      def getLoadBalancer(request: model.GetLoadBalancerRequest): IO[AwsError, model.GetLoadBalancerResponse.ReadOnly]
      def deleteInstanceSnapshot(request: model.DeleteInstanceSnapshotRequest): IO[AwsError, model.DeleteInstanceSnapshotResponse.ReadOnly]
      def deleteDomainEntry(request: model.DeleteDomainEntryRequest): IO[AwsError, model.DeleteDomainEntryResponse.ReadOnly]
      def updateRelationalDatabase(request: model.UpdateRelationalDatabaseRequest): IO[AwsError, model.UpdateRelationalDatabaseResponse.ReadOnly]
      def peerVpc(request: model.PeerVpcRequest): IO[AwsError, model.PeerVpcResponse.ReadOnly]
      def unpeerVpc(request: model.UnpeerVpcRequest): IO[AwsError, model.UnpeerVpcResponse.ReadOnly]
      def getActiveNames(request: model.GetActiveNamesRequest): IO[AwsError, model.GetActiveNamesResponse.ReadOnly]
      def getAutoSnapshots(request: model.GetAutoSnapshotsRequest): IO[AwsError, model.GetAutoSnapshotsResponse.ReadOnly]
      def startRelationalDatabase(request: model.StartRelationalDatabaseRequest): IO[AwsError, model.StartRelationalDatabaseResponse.ReadOnly]
      def createInstanceSnapshot(request: model.CreateInstanceSnapshotRequest): IO[AwsError, model.CreateInstanceSnapshotResponse.ReadOnly]
      def updateDomainEntry(request: model.UpdateDomainEntryRequest): IO[AwsError, model.UpdateDomainEntryResponse.ReadOnly]
      def rebootInstance(request: model.RebootInstanceRequest): IO[AwsError, model.RebootInstanceResponse.ReadOnly]
      def createContactMethod(request: model.CreateContactMethodRequest): IO[AwsError, model.CreateContactMethodResponse.ReadOnly]
      def getDiskSnapshots(request: model.GetDiskSnapshotsRequest): IO[AwsError, model.GetDiskSnapshotsResponse.ReadOnly]
      def getContainerLog(request: model.GetContainerLogRequest): IO[AwsError, model.GetContainerLogResponse.ReadOnly]
      def getContainerServiceDeployments(request: model.GetContainerServiceDeploymentsRequest): IO[AwsError, model.GetContainerServiceDeploymentsResponse.ReadOnly]
      def createDomain(request: model.CreateDomainRequest): IO[AwsError, model.CreateDomainResponse.ReadOnly]
      def createContainerService(request: model.CreateContainerServiceRequest): IO[AwsError, model.CreateContainerServiceResponse.ReadOnly]
      def isVpcPeered(request: model.IsVpcPeeredRequest): IO[AwsError, model.IsVpcPeeredResponse.ReadOnly]
      def deleteAutoSnapshot(request: model.DeleteAutoSnapshotRequest): IO[AwsError, model.DeleteAutoSnapshotResponse.ReadOnly]
      def createContainerServiceRegistryLogin(request: model.CreateContainerServiceRegistryLoginRequest): IO[AwsError, model.CreateContainerServiceRegistryLoginResponse.ReadOnly]
      def getDisk(request: model.GetDiskRequest): IO[AwsError, model.GetDiskResponse.ReadOnly]
      def enableAddOn(request: model.EnableAddOnRequest): IO[AwsError, model.EnableAddOnResponse.ReadOnly]
      def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly]
      def createLoadBalancerTlsCertificate(request: model.CreateLoadBalancerTlsCertificateRequest): IO[AwsError, model.CreateLoadBalancerTlsCertificateResponse.ReadOnly]
      def getStaticIp(request: model.GetStaticIpRequest): IO[AwsError, model.GetStaticIpResponse.ReadOnly]
      def attachStaticIp(request: model.AttachStaticIpRequest): IO[AwsError, model.AttachStaticIpResponse.ReadOnly]
      def importKeyPair(request: model.ImportKeyPairRequest): IO[AwsError, model.ImportKeyPairResponse.ReadOnly]
      def getDisks(request: model.GetDisksRequest): IO[AwsError, model.GetDisksResponse.ReadOnly]
      def downloadDefaultKeyPair(request: model.DownloadDefaultKeyPairRequest): IO[AwsError, model.DownloadDefaultKeyPairResponse.ReadOnly]
      def getExportSnapshotRecords(request: model.GetExportSnapshotRecordsRequest): IO[AwsError, model.GetExportSnapshotRecordsResponse.ReadOnly]
      def createKeyPair(request: model.CreateKeyPairRequest): IO[AwsError, model.CreateKeyPairResponse.ReadOnly]
      def getBundles(request: model.GetBundlesRequest): IO[AwsError, model.GetBundlesResponse.ReadOnly]
      def registerContainerImage(request: model.RegisterContainerImageRequest): IO[AwsError, model.RegisterContainerImageResponse.ReadOnly]
      def startInstance(request: model.StartInstanceRequest): IO[AwsError, model.StartInstanceResponse.ReadOnly]
      def getInstancePortStates(request: model.GetInstancePortStatesRequest): IO[AwsError, model.GetInstancePortStatesResponse.ReadOnly]
      def deleteDisk(request: model.DeleteDiskRequest): IO[AwsError, model.DeleteDiskResponse.ReadOnly]
      def getBlueprints(request: model.GetBlueprintsRequest): IO[AwsError, model.GetBlueprintsResponse.ReadOnly]
      def deleteAlarm(request: model.DeleteAlarmRequest): IO[AwsError, model.DeleteAlarmResponse.ReadOnly]
      def createRelationalDatabaseSnapshot(request: model.CreateRelationalDatabaseSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseSnapshotResponse.ReadOnly]
      def getContainerServiceMetricData(request: model.GetContainerServiceMetricDataRequest): IO[AwsError, model.GetContainerServiceMetricDataResponse.ReadOnly]
      def getRelationalDatabaseLogStreams(request: model.GetRelationalDatabaseLogStreamsRequest): IO[AwsError, model.GetRelationalDatabaseLogStreamsResponse.ReadOnly]
      def updateRelationalDatabaseParameters(request: model.UpdateRelationalDatabaseParametersRequest): IO[AwsError, model.UpdateRelationalDatabaseParametersResponse.ReadOnly]
      def createContainerServiceDeployment(request: model.CreateContainerServiceDeploymentRequest): IO[AwsError, model.CreateContainerServiceDeploymentResponse.ReadOnly]
      def getDistributionLatestCacheReset(request: model.GetDistributionLatestCacheResetRequest): IO[AwsError, model.GetDistributionLatestCacheResetResponse.ReadOnly]
      def updateDistributionBundle(request: model.UpdateDistributionBundleRequest): IO[AwsError, model.UpdateDistributionBundleResponse.ReadOnly]
      def deleteKeyPair(request: model.DeleteKeyPairRequest): IO[AwsError, model.DeleteKeyPairResponse.ReadOnly]
      def getStaticIps(request: model.GetStaticIpsRequest): IO[AwsError, model.GetStaticIpsResponse.ReadOnly]
      def createRelationalDatabase(request: model.CreateRelationalDatabaseRequest): IO[AwsError, model.CreateRelationalDatabaseResponse.ReadOnly]
      def getCertificates(request: model.GetCertificatesRequest): IO[AwsError, model.GetCertificatesResponse.ReadOnly]
      def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly]
      def deleteDomain(request: model.DeleteDomainRequest): IO[AwsError, model.DeleteDomainResponse.ReadOnly]
      def getRelationalDatabaseSnapshots(request: model.GetRelationalDatabaseSnapshotsRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotsResponse.ReadOnly]
      def createInstancesFromSnapshot(request: model.CreateInstancesFromSnapshotRequest): IO[AwsError, model.CreateInstancesFromSnapshotResponse.ReadOnly]
      def exportSnapshot(request: model.ExportSnapshotRequest): IO[AwsError, model.ExportSnapshotResponse.ReadOnly]
      def attachDisk(request: model.AttachDiskRequest): IO[AwsError, model.AttachDiskResponse.ReadOnly]
      def setIpAddressType(request: model.SetIpAddressTypeRequest): IO[AwsError, model.SetIpAddressTypeResponse.ReadOnly]
      def getRegions(request: model.GetRegionsRequest): IO[AwsError, model.GetRegionsResponse.ReadOnly]
      def getRelationalDatabaseMetricData(request: model.GetRelationalDatabaseMetricDataRequest): IO[AwsError, model.GetRelationalDatabaseMetricDataResponse.ReadOnly]
      def getOperation(request: model.GetOperationRequest): IO[AwsError, model.GetOperationResponse.ReadOnly]
      def stopInstance(request: model.StopInstanceRequest): IO[AwsError, model.StopInstanceResponse.ReadOnly]
      def getDistributionMetricData(request: model.GetDistributionMetricDataRequest): IO[AwsError, model.GetDistributionMetricDataResponse.ReadOnly]
      def getKeyPairs(request: model.GetKeyPairsRequest): IO[AwsError, model.GetKeyPairsResponse.ReadOnly]
      def disableAddOn(request: model.DisableAddOnRequest): IO[AwsError, model.DisableAddOnResponse.ReadOnly]
      def createInstances(request: model.CreateInstancesRequest): IO[AwsError, model.CreateInstancesResponse.ReadOnly]
      def createLoadBalancer(request: model.CreateLoadBalancerRequest): IO[AwsError, model.CreateLoadBalancerResponse.ReadOnly]
      def getRelationalDatabaseBlueprints(request: model.GetRelationalDatabaseBlueprintsRequest): IO[AwsError, model.GetRelationalDatabaseBlueprintsResponse.ReadOnly]
      def detachCertificateFromDistribution(request: model.DetachCertificateFromDistributionRequest): IO[AwsError, model.DetachCertificateFromDistributionResponse.ReadOnly]
      def getRelationalDatabaseMasterUserPassword(request: model.GetRelationalDatabaseMasterUserPasswordRequest): IO[AwsError, model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly]
      def updateContainerService(request: model.UpdateContainerServiceRequest): IO[AwsError, model.UpdateContainerServiceResponse.ReadOnly]
      def getContainerServicePowers(request: model.GetContainerServicePowersRequest): IO[AwsError, model.GetContainerServicePowersResponse.ReadOnly]
      def getRelationalDatabase(request: model.GetRelationalDatabaseRequest): IO[AwsError, model.GetRelationalDatabaseResponse.ReadOnly]
      def getCloudFormationStackRecords(request: model.GetCloudFormationStackRecordsRequest): IO[AwsError, model.GetCloudFormationStackRecordsResponse.ReadOnly]
      def updateDistribution(request: model.UpdateDistributionRequest): IO[AwsError, model.UpdateDistributionResponse.ReadOnly]
      def deleteDistribution(request: model.DeleteDistributionRequest): IO[AwsError, model.DeleteDistributionResponse.ReadOnly]
      def deleteContainerImage(request: model.DeleteContainerImageRequest): IO[AwsError, model.DeleteContainerImageResponse.ReadOnly]
      def createDistribution(request: model.CreateDistributionRequest): IO[AwsError, model.CreateDistributionResponse.ReadOnly]
    }
    object LightsailMock extends zio.test.mock.Mock[Lightsail] {
      object PutInstancePublicPorts extends Effect[model.PutInstancePublicPortsRequest, AwsError, model.PutInstancePublicPortsResponse.ReadOnly]
      object ResetDistributionCache extends Effect[model.ResetDistributionCacheRequest, AwsError, model.ResetDistributionCacheResponse.ReadOnly]
      object GetRelationalDatabaseSnapshot extends Effect[model.GetRelationalDatabaseSnapshotRequest, AwsError, model.GetRelationalDatabaseSnapshotResponse.ReadOnly]
      object GetKeyPair extends Effect[model.GetKeyPairRequest, AwsError, model.GetKeyPairResponse.ReadOnly]
      object GetInstanceAccessDetails extends Effect[model.GetInstanceAccessDetailsRequest, AwsError, model.GetInstanceAccessDetailsResponse.ReadOnly]
      object DeleteLoadBalancerTlsCertificate extends Effect[model.DeleteLoadBalancerTlsCertificateRequest, AwsError, model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly]
      object CreateDiskSnapshot extends Effect[model.CreateDiskSnapshotRequest, AwsError, model.CreateDiskSnapshotResponse.ReadOnly]
      object DeleteRelationalDatabase extends Effect[model.DeleteRelationalDatabaseRequest, AwsError, model.DeleteRelationalDatabaseResponse.ReadOnly]
      object ReleaseStaticIp extends Effect[model.ReleaseStaticIpRequest, AwsError, model.ReleaseStaticIpResponse.ReadOnly]
      object UpdateLoadBalancerAttribute extends Effect[model.UpdateLoadBalancerAttributeRequest, AwsError, model.UpdateLoadBalancerAttributeResponse.ReadOnly]
      object TestAlarm extends Effect[model.TestAlarmRequest, AwsError, model.TestAlarmResponse.ReadOnly]
      object CloseInstancePublicPorts extends Effect[model.CloseInstancePublicPortsRequest, AwsError, model.CloseInstancePublicPortsResponse.ReadOnly]
      object DeleteContactMethod extends Effect[model.DeleteContactMethodRequest, AwsError, model.DeleteContactMethodResponse.ReadOnly]
      object DeleteDiskSnapshot extends Effect[model.DeleteDiskSnapshotRequest, AwsError, model.DeleteDiskSnapshotResponse.ReadOnly]
      object PutAlarm extends Effect[model.PutAlarmRequest, AwsError, model.PutAlarmResponse.ReadOnly]
      object GetInstances extends Effect[model.GetInstancesRequest, AwsError, model.GetInstancesResponse.ReadOnly]
      object CreateCertificate extends Effect[model.CreateCertificateRequest, AwsError, model.CreateCertificateResponse.ReadOnly]
      object GetRelationalDatabaseLogEvents extends Effect[model.GetRelationalDatabaseLogEventsRequest, AwsError, model.GetRelationalDatabaseLogEventsResponse.ReadOnly]
      object DeleteKnownHostKeys extends Effect[model.DeleteKnownHostKeysRequest, AwsError, model.DeleteKnownHostKeysResponse.ReadOnly]
      object RebootRelationalDatabase extends Effect[model.RebootRelationalDatabaseRequest, AwsError, model.RebootRelationalDatabaseResponse.ReadOnly]
      object CreateCloudFormationStack extends Effect[model.CreateCloudFormationStackRequest, AwsError, model.CreateCloudFormationStackResponse.ReadOnly]
      object DetachDisk extends Effect[model.DetachDiskRequest, AwsError, model.DetachDiskResponse.ReadOnly]
      object AllocateStaticIp extends Effect[model.AllocateStaticIpRequest, AwsError, model.AllocateStaticIpResponse.ReadOnly]
      object GetRelationalDatabaseEvents extends Effect[model.GetRelationalDatabaseEventsRequest, AwsError, model.GetRelationalDatabaseEventsResponse.ReadOnly]
      object GetOperations extends Effect[model.GetOperationsRequest, AwsError, model.GetOperationsResponse.ReadOnly]
      object GetInstanceState extends Effect[model.GetInstanceStateRequest, AwsError, model.GetInstanceStateResponse.ReadOnly]
      object GetDomains extends Effect[model.GetDomainsRequest, AwsError, model.GetDomainsResponse.ReadOnly]
      object GetLoadBalancers extends Effect[model.GetLoadBalancersRequest, AwsError, model.GetLoadBalancersResponse.ReadOnly]
      object GetContainerServices extends Effect[model.GetContainerServicesRequest, AwsError, model.GetContainerServicesResponse.ReadOnly]
      object GetLoadBalancerTlsCertificates extends Effect[model.GetLoadBalancerTlsCertificatesRequest, AwsError, model.GetLoadBalancerTlsCertificatesResponse.ReadOnly]
      object CreateRelationalDatabaseFromSnapshot extends Effect[model.CreateRelationalDatabaseFromSnapshotRequest, AwsError, model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly]
      object GetInstanceSnapshot extends Effect[model.GetInstanceSnapshotRequest, AwsError, model.GetInstanceSnapshotResponse.ReadOnly]
      object DeleteContainerService extends Effect[model.DeleteContainerServiceRequest, AwsError, model.DeleteContainerServiceResponse.ReadOnly]
      object GetContainerAPIMetadata extends Effect[model.GetContainerApiMetadataRequest, AwsError, model.GetContainerApiMetadataResponse.ReadOnly]
      object GetDiskSnapshot extends Effect[model.GetDiskSnapshotRequest, AwsError, model.GetDiskSnapshotResponse.ReadOnly]
      object DetachStaticIp extends Effect[model.DetachStaticIpRequest, AwsError, model.DetachStaticIpResponse.ReadOnly]
      object CreateDisk extends Effect[model.CreateDiskRequest, AwsError, model.CreateDiskResponse.ReadOnly]
      object GetContainerImages extends Effect[model.GetContainerImagesRequest, AwsError, model.GetContainerImagesResponse.ReadOnly]
      object CreateDomainEntry extends Effect[model.CreateDomainEntryRequest, AwsError, model.CreateDomainEntryResponse.ReadOnly]
      object SendContactMethodVerification extends Effect[model.SendContactMethodVerificationRequest, AwsError, model.SendContactMethodVerificationResponse.ReadOnly]
      object GetDomain extends Effect[model.GetDomainRequest, AwsError, model.GetDomainResponse.ReadOnly]
      object DeleteInstance extends Effect[model.DeleteInstanceRequest, AwsError, model.DeleteInstanceResponse.ReadOnly]
      object CopySnapshot extends Effect[model.CopySnapshotRequest, AwsError, model.CopySnapshotResponse.ReadOnly]
      object GetContactMethods extends Effect[model.GetContactMethodsRequest, AwsError, model.GetContactMethodsResponse.ReadOnly]
      object GetRelationalDatabaseBundles extends Effect[model.GetRelationalDatabaseBundlesRequest, AwsError, model.GetRelationalDatabaseBundlesResponse.ReadOnly]
      object DetachInstancesFromLoadBalancer extends Effect[model.DetachInstancesFromLoadBalancerRequest, AwsError, model.DetachInstancesFromLoadBalancerResponse.ReadOnly]
      object OpenInstancePublicPorts extends Effect[model.OpenInstancePublicPortsRequest, AwsError, model.OpenInstancePublicPortsResponse.ReadOnly]
      object GetInstanceMetricData extends Effect[model.GetInstanceMetricDataRequest, AwsError, model.GetInstanceMetricDataResponse.ReadOnly]
      object DeleteRelationalDatabaseSnapshot extends Effect[model.DeleteRelationalDatabaseSnapshotRequest, AwsError, model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly]
      object AttachInstancesToLoadBalancer extends Effect[model.AttachInstancesToLoadBalancerRequest, AwsError, model.AttachInstancesToLoadBalancerResponse.ReadOnly]
      object GetDistributionBundles extends Effect[model.GetDistributionBundlesRequest, AwsError, model.GetDistributionBundlesResponse.ReadOnly]
      object GetRelationalDatabaseParameters extends Effect[model.GetRelationalDatabaseParametersRequest, AwsError, model.GetRelationalDatabaseParametersResponse.ReadOnly]
      object GetAlarms extends Effect[model.GetAlarmsRequest, AwsError, model.GetAlarmsResponse.ReadOnly]
      object DeleteLoadBalancer extends Effect[model.DeleteLoadBalancerRequest, AwsError, model.DeleteLoadBalancerResponse.ReadOnly]
      object GetInstanceSnapshots extends Effect[model.GetInstanceSnapshotsRequest, AwsError, model.GetInstanceSnapshotsResponse.ReadOnly]
      object StopRelationalDatabase extends Effect[model.StopRelationalDatabaseRequest, AwsError, model.StopRelationalDatabaseResponse.ReadOnly]
      object GetLoadBalancerMetricData extends Effect[model.GetLoadBalancerMetricDataRequest, AwsError, model.GetLoadBalancerMetricDataResponse.ReadOnly]
      object AttachCertificateToDistribution extends Effect[model.AttachCertificateToDistributionRequest, AwsError, model.AttachCertificateToDistributionResponse.ReadOnly]
      object DeleteCertificate extends Effect[model.DeleteCertificateRequest, AwsError, model.DeleteCertificateResponse.ReadOnly]
      object GetInstance extends Effect[model.GetInstanceRequest, AwsError, model.GetInstanceResponse.ReadOnly]
      object GetDistributions extends Effect[model.GetDistributionsRequest, AwsError, model.GetDistributionsResponse.ReadOnly]
      object GetRelationalDatabases extends Effect[model.GetRelationalDatabasesRequest, AwsError, model.GetRelationalDatabasesResponse.ReadOnly]
      object AttachLoadBalancerTlsCertificate extends Effect[model.AttachLoadBalancerTlsCertificateRequest, AwsError, model.AttachLoadBalancerTlsCertificateResponse.ReadOnly]
      object GetOperationsForResource extends Effect[model.GetOperationsForResourceRequest, AwsError, model.GetOperationsForResourceResponse.ReadOnly]
      object CreateDiskFromSnapshot extends Effect[model.CreateDiskFromSnapshotRequest, AwsError, model.CreateDiskFromSnapshotResponse.ReadOnly]
      object GetLoadBalancer extends Effect[model.GetLoadBalancerRequest, AwsError, model.GetLoadBalancerResponse.ReadOnly]
      object DeleteInstanceSnapshot extends Effect[model.DeleteInstanceSnapshotRequest, AwsError, model.DeleteInstanceSnapshotResponse.ReadOnly]
      object DeleteDomainEntry extends Effect[model.DeleteDomainEntryRequest, AwsError, model.DeleteDomainEntryResponse.ReadOnly]
      object UpdateRelationalDatabase extends Effect[model.UpdateRelationalDatabaseRequest, AwsError, model.UpdateRelationalDatabaseResponse.ReadOnly]
      object PeerVpc extends Effect[model.PeerVpcRequest, AwsError, model.PeerVpcResponse.ReadOnly]
      object UnpeerVpc extends Effect[model.UnpeerVpcRequest, AwsError, model.UnpeerVpcResponse.ReadOnly]
      object GetActiveNames extends Effect[model.GetActiveNamesRequest, AwsError, model.GetActiveNamesResponse.ReadOnly]
      object GetAutoSnapshots extends Effect[model.GetAutoSnapshotsRequest, AwsError, model.GetAutoSnapshotsResponse.ReadOnly]
      object StartRelationalDatabase extends Effect[model.StartRelationalDatabaseRequest, AwsError, model.StartRelationalDatabaseResponse.ReadOnly]
      object CreateInstanceSnapshot extends Effect[model.CreateInstanceSnapshotRequest, AwsError, model.CreateInstanceSnapshotResponse.ReadOnly]
      object UpdateDomainEntry extends Effect[model.UpdateDomainEntryRequest, AwsError, model.UpdateDomainEntryResponse.ReadOnly]
      object RebootInstance extends Effect[model.RebootInstanceRequest, AwsError, model.RebootInstanceResponse.ReadOnly]
      object CreateContactMethod extends Effect[model.CreateContactMethodRequest, AwsError, model.CreateContactMethodResponse.ReadOnly]
      object GetDiskSnapshots extends Effect[model.GetDiskSnapshotsRequest, AwsError, model.GetDiskSnapshotsResponse.ReadOnly]
      object GetContainerLog extends Effect[model.GetContainerLogRequest, AwsError, model.GetContainerLogResponse.ReadOnly]
      object GetContainerServiceDeployments extends Effect[model.GetContainerServiceDeploymentsRequest, AwsError, model.GetContainerServiceDeploymentsResponse.ReadOnly]
      object CreateDomain extends Effect[model.CreateDomainRequest, AwsError, model.CreateDomainResponse.ReadOnly]
      object CreateContainerService extends Effect[model.CreateContainerServiceRequest, AwsError, model.CreateContainerServiceResponse.ReadOnly]
      object IsVpcPeered extends Effect[model.IsVpcPeeredRequest, AwsError, model.IsVpcPeeredResponse.ReadOnly]
      object DeleteAutoSnapshot extends Effect[model.DeleteAutoSnapshotRequest, AwsError, model.DeleteAutoSnapshotResponse.ReadOnly]
      object CreateContainerServiceRegistryLogin extends Effect[model.CreateContainerServiceRegistryLoginRequest, AwsError, model.CreateContainerServiceRegistryLoginResponse.ReadOnly]
      object GetDisk extends Effect[model.GetDiskRequest, AwsError, model.GetDiskResponse.ReadOnly]
      object EnableAddOn extends Effect[model.EnableAddOnRequest, AwsError, model.EnableAddOnResponse.ReadOnly]
      object UntagResource extends Effect[model.UntagResourceRequest, AwsError, model.UntagResourceResponse.ReadOnly]
      object CreateLoadBalancerTlsCertificate extends Effect[model.CreateLoadBalancerTlsCertificateRequest, AwsError, model.CreateLoadBalancerTlsCertificateResponse.ReadOnly]
      object GetStaticIp extends Effect[model.GetStaticIpRequest, AwsError, model.GetStaticIpResponse.ReadOnly]
      object AttachStaticIp extends Effect[model.AttachStaticIpRequest, AwsError, model.AttachStaticIpResponse.ReadOnly]
      object ImportKeyPair extends Effect[model.ImportKeyPairRequest, AwsError, model.ImportKeyPairResponse.ReadOnly]
      object GetDisks extends Effect[model.GetDisksRequest, AwsError, model.GetDisksResponse.ReadOnly]
      object DownloadDefaultKeyPair extends Effect[model.DownloadDefaultKeyPairRequest, AwsError, model.DownloadDefaultKeyPairResponse.ReadOnly]
      object GetExportSnapshotRecords extends Effect[model.GetExportSnapshotRecordsRequest, AwsError, model.GetExportSnapshotRecordsResponse.ReadOnly]
      object CreateKeyPair extends Effect[model.CreateKeyPairRequest, AwsError, model.CreateKeyPairResponse.ReadOnly]
      object GetBundles extends Effect[model.GetBundlesRequest, AwsError, model.GetBundlesResponse.ReadOnly]
      object RegisterContainerImage extends Effect[model.RegisterContainerImageRequest, AwsError, model.RegisterContainerImageResponse.ReadOnly]
      object StartInstance extends Effect[model.StartInstanceRequest, AwsError, model.StartInstanceResponse.ReadOnly]
      object GetInstancePortStates extends Effect[model.GetInstancePortStatesRequest, AwsError, model.GetInstancePortStatesResponse.ReadOnly]
      object DeleteDisk extends Effect[model.DeleteDiskRequest, AwsError, model.DeleteDiskResponse.ReadOnly]
      object GetBlueprints extends Effect[model.GetBlueprintsRequest, AwsError, model.GetBlueprintsResponse.ReadOnly]
      object DeleteAlarm extends Effect[model.DeleteAlarmRequest, AwsError, model.DeleteAlarmResponse.ReadOnly]
      object CreateRelationalDatabaseSnapshot extends Effect[model.CreateRelationalDatabaseSnapshotRequest, AwsError, model.CreateRelationalDatabaseSnapshotResponse.ReadOnly]
      object GetContainerServiceMetricData extends Effect[model.GetContainerServiceMetricDataRequest, AwsError, model.GetContainerServiceMetricDataResponse.ReadOnly]
      object GetRelationalDatabaseLogStreams extends Effect[model.GetRelationalDatabaseLogStreamsRequest, AwsError, model.GetRelationalDatabaseLogStreamsResponse.ReadOnly]
      object UpdateRelationalDatabaseParameters extends Effect[model.UpdateRelationalDatabaseParametersRequest, AwsError, model.UpdateRelationalDatabaseParametersResponse.ReadOnly]
      object CreateContainerServiceDeployment extends Effect[model.CreateContainerServiceDeploymentRequest, AwsError, model.CreateContainerServiceDeploymentResponse.ReadOnly]
      object GetDistributionLatestCacheReset extends Effect[model.GetDistributionLatestCacheResetRequest, AwsError, model.GetDistributionLatestCacheResetResponse.ReadOnly]
      object UpdateDistributionBundle extends Effect[model.UpdateDistributionBundleRequest, AwsError, model.UpdateDistributionBundleResponse.ReadOnly]
      object DeleteKeyPair extends Effect[model.DeleteKeyPairRequest, AwsError, model.DeleteKeyPairResponse.ReadOnly]
      object GetStaticIps extends Effect[model.GetStaticIpsRequest, AwsError, model.GetStaticIpsResponse.ReadOnly]
      object CreateRelationalDatabase extends Effect[model.CreateRelationalDatabaseRequest, AwsError, model.CreateRelationalDatabaseResponse.ReadOnly]
      object GetCertificates extends Effect[model.GetCertificatesRequest, AwsError, model.GetCertificatesResponse.ReadOnly]
      object TagResource extends Effect[model.TagResourceRequest, AwsError, model.TagResourceResponse.ReadOnly]
      object DeleteDomain extends Effect[model.DeleteDomainRequest, AwsError, model.DeleteDomainResponse.ReadOnly]
      object GetRelationalDatabaseSnapshots extends Effect[model.GetRelationalDatabaseSnapshotsRequest, AwsError, model.GetRelationalDatabaseSnapshotsResponse.ReadOnly]
      object CreateInstancesFromSnapshot extends Effect[model.CreateInstancesFromSnapshotRequest, AwsError, model.CreateInstancesFromSnapshotResponse.ReadOnly]
      object ExportSnapshot extends Effect[model.ExportSnapshotRequest, AwsError, model.ExportSnapshotResponse.ReadOnly]
      object AttachDisk extends Effect[model.AttachDiskRequest, AwsError, model.AttachDiskResponse.ReadOnly]
      object SetIpAddressType extends Effect[model.SetIpAddressTypeRequest, AwsError, model.SetIpAddressTypeResponse.ReadOnly]
      object GetRegions extends Effect[model.GetRegionsRequest, AwsError, model.GetRegionsResponse.ReadOnly]
      object GetRelationalDatabaseMetricData extends Effect[model.GetRelationalDatabaseMetricDataRequest, AwsError, model.GetRelationalDatabaseMetricDataResponse.ReadOnly]
      object GetOperation extends Effect[model.GetOperationRequest, AwsError, model.GetOperationResponse.ReadOnly]
      object StopInstance extends Effect[model.StopInstanceRequest, AwsError, model.StopInstanceResponse.ReadOnly]
      object GetDistributionMetricData extends Effect[model.GetDistributionMetricDataRequest, AwsError, model.GetDistributionMetricDataResponse.ReadOnly]
      object GetKeyPairs extends Effect[model.GetKeyPairsRequest, AwsError, model.GetKeyPairsResponse.ReadOnly]
      object DisableAddOn extends Effect[model.DisableAddOnRequest, AwsError, model.DisableAddOnResponse.ReadOnly]
      object CreateInstances extends Effect[model.CreateInstancesRequest, AwsError, model.CreateInstancesResponse.ReadOnly]
      object CreateLoadBalancer extends Effect[model.CreateLoadBalancerRequest, AwsError, model.CreateLoadBalancerResponse.ReadOnly]
      object GetRelationalDatabaseBlueprints extends Effect[model.GetRelationalDatabaseBlueprintsRequest, AwsError, model.GetRelationalDatabaseBlueprintsResponse.ReadOnly]
      object DetachCertificateFromDistribution extends Effect[model.DetachCertificateFromDistributionRequest, AwsError, model.DetachCertificateFromDistributionResponse.ReadOnly]
      object GetRelationalDatabaseMasterUserPassword extends Effect[model.GetRelationalDatabaseMasterUserPasswordRequest, AwsError, model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly]
      object UpdateContainerService extends Effect[model.UpdateContainerServiceRequest, AwsError, model.UpdateContainerServiceResponse.ReadOnly]
      object GetContainerServicePowers extends Effect[model.GetContainerServicePowersRequest, AwsError, model.GetContainerServicePowersResponse.ReadOnly]
      object GetRelationalDatabase extends Effect[model.GetRelationalDatabaseRequest, AwsError, model.GetRelationalDatabaseResponse.ReadOnly]
      object GetCloudFormationStackRecords extends Effect[model.GetCloudFormationStackRecordsRequest, AwsError, model.GetCloudFormationStackRecordsResponse.ReadOnly]
      object UpdateDistribution extends Effect[model.UpdateDistributionRequest, AwsError, model.UpdateDistributionResponse.ReadOnly]
      object DeleteDistribution extends Effect[model.DeleteDistributionRequest, AwsError, model.DeleteDistributionResponse.ReadOnly]
      object DeleteContainerImage extends Effect[model.DeleteContainerImageRequest, AwsError, model.DeleteContainerImageResponse.ReadOnly]
      object CreateDistribution extends Effect[model.CreateDistributionRequest, AwsError, model.CreateDistributionResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], Lightsail] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new Lightsail.Service {
            val api: LightsailAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): Lightsail.Service = this
            def putInstancePublicPorts(request: model.PutInstancePublicPortsRequest): IO[AwsError, model.PutInstancePublicPortsResponse.ReadOnly] = proxy(PutInstancePublicPorts, request)
            def resetDistributionCache(request: model.ResetDistributionCacheRequest): IO[AwsError, model.ResetDistributionCacheResponse.ReadOnly] = proxy(ResetDistributionCache, request)
            def getRelationalDatabaseSnapshot(request: model.GetRelationalDatabaseSnapshotRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotResponse.ReadOnly] = proxy(GetRelationalDatabaseSnapshot, request)
            def getKeyPair(request: model.GetKeyPairRequest): IO[AwsError, model.GetKeyPairResponse.ReadOnly] = proxy(GetKeyPair, request)
            def getInstanceAccessDetails(request: model.GetInstanceAccessDetailsRequest): IO[AwsError, model.GetInstanceAccessDetailsResponse.ReadOnly] = proxy(GetInstanceAccessDetails, request)
            def deleteLoadBalancerTlsCertificate(request: model.DeleteLoadBalancerTlsCertificateRequest): IO[AwsError, model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly] = proxy(DeleteLoadBalancerTlsCertificate, request)
            def createDiskSnapshot(request: model.CreateDiskSnapshotRequest): IO[AwsError, model.CreateDiskSnapshotResponse.ReadOnly] = proxy(CreateDiskSnapshot, request)
            def deleteRelationalDatabase(request: model.DeleteRelationalDatabaseRequest): IO[AwsError, model.DeleteRelationalDatabaseResponse.ReadOnly] = proxy(DeleteRelationalDatabase, request)
            def releaseStaticIp(request: model.ReleaseStaticIpRequest): IO[AwsError, model.ReleaseStaticIpResponse.ReadOnly] = proxy(ReleaseStaticIp, request)
            def updateLoadBalancerAttribute(request: model.UpdateLoadBalancerAttributeRequest): IO[AwsError, model.UpdateLoadBalancerAttributeResponse.ReadOnly] = proxy(UpdateLoadBalancerAttribute, request)
            def testAlarm(request: model.TestAlarmRequest): IO[AwsError, model.TestAlarmResponse.ReadOnly] = proxy(TestAlarm, request)
            def closeInstancePublicPorts(request: model.CloseInstancePublicPortsRequest): IO[AwsError, model.CloseInstancePublicPortsResponse.ReadOnly] = proxy(CloseInstancePublicPorts, request)
            def deleteContactMethod(request: model.DeleteContactMethodRequest): IO[AwsError, model.DeleteContactMethodResponse.ReadOnly] = proxy(DeleteContactMethod, request)
            def deleteDiskSnapshot(request: model.DeleteDiskSnapshotRequest): IO[AwsError, model.DeleteDiskSnapshotResponse.ReadOnly] = proxy(DeleteDiskSnapshot, request)
            def putAlarm(request: model.PutAlarmRequest): IO[AwsError, model.PutAlarmResponse.ReadOnly] = proxy(PutAlarm, request)
            def getInstances(request: model.GetInstancesRequest): IO[AwsError, model.GetInstancesResponse.ReadOnly] = proxy(GetInstances, request)
            def createCertificate(request: model.CreateCertificateRequest): IO[AwsError, model.CreateCertificateResponse.ReadOnly] = proxy(CreateCertificate, request)
            def getRelationalDatabaseLogEvents(request: model.GetRelationalDatabaseLogEventsRequest): IO[AwsError, model.GetRelationalDatabaseLogEventsResponse.ReadOnly] = proxy(GetRelationalDatabaseLogEvents, request)
            def deleteKnownHostKeys(request: model.DeleteKnownHostKeysRequest): IO[AwsError, model.DeleteKnownHostKeysResponse.ReadOnly] = proxy(DeleteKnownHostKeys, request)
            def rebootRelationalDatabase(request: model.RebootRelationalDatabaseRequest): IO[AwsError, model.RebootRelationalDatabaseResponse.ReadOnly] = proxy(RebootRelationalDatabase, request)
            def createCloudFormationStack(request: model.CreateCloudFormationStackRequest): IO[AwsError, model.CreateCloudFormationStackResponse.ReadOnly] = proxy(CreateCloudFormationStack, request)
            def detachDisk(request: model.DetachDiskRequest): IO[AwsError, model.DetachDiskResponse.ReadOnly] = proxy(DetachDisk, request)
            def allocateStaticIp(request: model.AllocateStaticIpRequest): IO[AwsError, model.AllocateStaticIpResponse.ReadOnly] = proxy(AllocateStaticIp, request)
            def getRelationalDatabaseEvents(request: model.GetRelationalDatabaseEventsRequest): IO[AwsError, model.GetRelationalDatabaseEventsResponse.ReadOnly] = proxy(GetRelationalDatabaseEvents, request)
            def getOperations(request: model.GetOperationsRequest): IO[AwsError, model.GetOperationsResponse.ReadOnly] = proxy(GetOperations, request)
            def getInstanceState(request: model.GetInstanceStateRequest): IO[AwsError, model.GetInstanceStateResponse.ReadOnly] = proxy(GetInstanceState, request)
            def getDomains(request: model.GetDomainsRequest): IO[AwsError, model.GetDomainsResponse.ReadOnly] = proxy(GetDomains, request)
            def getLoadBalancers(request: model.GetLoadBalancersRequest): IO[AwsError, model.GetLoadBalancersResponse.ReadOnly] = proxy(GetLoadBalancers, request)
            def getContainerServices(request: model.GetContainerServicesRequest): IO[AwsError, model.GetContainerServicesResponse.ReadOnly] = proxy(GetContainerServices, request)
            def getLoadBalancerTlsCertificates(request: model.GetLoadBalancerTlsCertificatesRequest): IO[AwsError, model.GetLoadBalancerTlsCertificatesResponse.ReadOnly] = proxy(GetLoadBalancerTlsCertificates, request)
            def createRelationalDatabaseFromSnapshot(request: model.CreateRelationalDatabaseFromSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly] = proxy(CreateRelationalDatabaseFromSnapshot, request)
            def getInstanceSnapshot(request: model.GetInstanceSnapshotRequest): IO[AwsError, model.GetInstanceSnapshotResponse.ReadOnly] = proxy(GetInstanceSnapshot, request)
            def deleteContainerService(request: model.DeleteContainerServiceRequest): IO[AwsError, model.DeleteContainerServiceResponse.ReadOnly] = proxy(DeleteContainerService, request)
            def getContainerAPIMetadata(request: model.GetContainerApiMetadataRequest): IO[AwsError, model.GetContainerApiMetadataResponse.ReadOnly] = proxy(GetContainerAPIMetadata, request)
            def getDiskSnapshot(request: model.GetDiskSnapshotRequest): IO[AwsError, model.GetDiskSnapshotResponse.ReadOnly] = proxy(GetDiskSnapshot, request)
            def detachStaticIp(request: model.DetachStaticIpRequest): IO[AwsError, model.DetachStaticIpResponse.ReadOnly] = proxy(DetachStaticIp, request)
            def createDisk(request: model.CreateDiskRequest): IO[AwsError, model.CreateDiskResponse.ReadOnly] = proxy(CreateDisk, request)
            def getContainerImages(request: model.GetContainerImagesRequest): IO[AwsError, model.GetContainerImagesResponse.ReadOnly] = proxy(GetContainerImages, request)
            def createDomainEntry(request: model.CreateDomainEntryRequest): IO[AwsError, model.CreateDomainEntryResponse.ReadOnly] = proxy(CreateDomainEntry, request)
            def sendContactMethodVerification(request: model.SendContactMethodVerificationRequest): IO[AwsError, model.SendContactMethodVerificationResponse.ReadOnly] = proxy(SendContactMethodVerification, request)
            def getDomain(request: model.GetDomainRequest): IO[AwsError, model.GetDomainResponse.ReadOnly] = proxy(GetDomain, request)
            def deleteInstance(request: model.DeleteInstanceRequest): IO[AwsError, model.DeleteInstanceResponse.ReadOnly] = proxy(DeleteInstance, request)
            def copySnapshot(request: model.CopySnapshotRequest): IO[AwsError, model.CopySnapshotResponse.ReadOnly] = proxy(CopySnapshot, request)
            def getContactMethods(request: model.GetContactMethodsRequest): IO[AwsError, model.GetContactMethodsResponse.ReadOnly] = proxy(GetContactMethods, request)
            def getRelationalDatabaseBundles(request: model.GetRelationalDatabaseBundlesRequest): IO[AwsError, model.GetRelationalDatabaseBundlesResponse.ReadOnly] = proxy(GetRelationalDatabaseBundles, request)
            def detachInstancesFromLoadBalancer(request: model.DetachInstancesFromLoadBalancerRequest): IO[AwsError, model.DetachInstancesFromLoadBalancerResponse.ReadOnly] = proxy(DetachInstancesFromLoadBalancer, request)
            def openInstancePublicPorts(request: model.OpenInstancePublicPortsRequest): IO[AwsError, model.OpenInstancePublicPortsResponse.ReadOnly] = proxy(OpenInstancePublicPorts, request)
            def getInstanceMetricData(request: model.GetInstanceMetricDataRequest): IO[AwsError, model.GetInstanceMetricDataResponse.ReadOnly] = proxy(GetInstanceMetricData, request)
            def deleteRelationalDatabaseSnapshot(request: model.DeleteRelationalDatabaseSnapshotRequest): IO[AwsError, model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly] = proxy(DeleteRelationalDatabaseSnapshot, request)
            def attachInstancesToLoadBalancer(request: model.AttachInstancesToLoadBalancerRequest): IO[AwsError, model.AttachInstancesToLoadBalancerResponse.ReadOnly] = proxy(AttachInstancesToLoadBalancer, request)
            def getDistributionBundles(request: model.GetDistributionBundlesRequest): IO[AwsError, model.GetDistributionBundlesResponse.ReadOnly] = proxy(GetDistributionBundles, request)
            def getRelationalDatabaseParameters(request: model.GetRelationalDatabaseParametersRequest): IO[AwsError, model.GetRelationalDatabaseParametersResponse.ReadOnly] = proxy(GetRelationalDatabaseParameters, request)
            def getAlarms(request: model.GetAlarmsRequest): IO[AwsError, model.GetAlarmsResponse.ReadOnly] = proxy(GetAlarms, request)
            def deleteLoadBalancer(request: model.DeleteLoadBalancerRequest): IO[AwsError, model.DeleteLoadBalancerResponse.ReadOnly] = proxy(DeleteLoadBalancer, request)
            def getInstanceSnapshots(request: model.GetInstanceSnapshotsRequest): IO[AwsError, model.GetInstanceSnapshotsResponse.ReadOnly] = proxy(GetInstanceSnapshots, request)
            def stopRelationalDatabase(request: model.StopRelationalDatabaseRequest): IO[AwsError, model.StopRelationalDatabaseResponse.ReadOnly] = proxy(StopRelationalDatabase, request)
            def getLoadBalancerMetricData(request: model.GetLoadBalancerMetricDataRequest): IO[AwsError, model.GetLoadBalancerMetricDataResponse.ReadOnly] = proxy(GetLoadBalancerMetricData, request)
            def attachCertificateToDistribution(request: model.AttachCertificateToDistributionRequest): IO[AwsError, model.AttachCertificateToDistributionResponse.ReadOnly] = proxy(AttachCertificateToDistribution, request)
            def deleteCertificate(request: model.DeleteCertificateRequest): IO[AwsError, model.DeleteCertificateResponse.ReadOnly] = proxy(DeleteCertificate, request)
            def getInstance(request: model.GetInstanceRequest): IO[AwsError, model.GetInstanceResponse.ReadOnly] = proxy(GetInstance, request)
            def getDistributions(request: model.GetDistributionsRequest): IO[AwsError, model.GetDistributionsResponse.ReadOnly] = proxy(GetDistributions, request)
            def getRelationalDatabases(request: model.GetRelationalDatabasesRequest): IO[AwsError, model.GetRelationalDatabasesResponse.ReadOnly] = proxy(GetRelationalDatabases, request)
            def attachLoadBalancerTlsCertificate(request: model.AttachLoadBalancerTlsCertificateRequest): IO[AwsError, model.AttachLoadBalancerTlsCertificateResponse.ReadOnly] = proxy(AttachLoadBalancerTlsCertificate, request)
            def getOperationsForResource(request: model.GetOperationsForResourceRequest): IO[AwsError, model.GetOperationsForResourceResponse.ReadOnly] = proxy(GetOperationsForResource, request)
            def createDiskFromSnapshot(request: model.CreateDiskFromSnapshotRequest): IO[AwsError, model.CreateDiskFromSnapshotResponse.ReadOnly] = proxy(CreateDiskFromSnapshot, request)
            def getLoadBalancer(request: model.GetLoadBalancerRequest): IO[AwsError, model.GetLoadBalancerResponse.ReadOnly] = proxy(GetLoadBalancer, request)
            def deleteInstanceSnapshot(request: model.DeleteInstanceSnapshotRequest): IO[AwsError, model.DeleteInstanceSnapshotResponse.ReadOnly] = proxy(DeleteInstanceSnapshot, request)
            def deleteDomainEntry(request: model.DeleteDomainEntryRequest): IO[AwsError, model.DeleteDomainEntryResponse.ReadOnly] = proxy(DeleteDomainEntry, request)
            def updateRelationalDatabase(request: model.UpdateRelationalDatabaseRequest): IO[AwsError, model.UpdateRelationalDatabaseResponse.ReadOnly] = proxy(UpdateRelationalDatabase, request)
            def peerVpc(request: model.PeerVpcRequest): IO[AwsError, model.PeerVpcResponse.ReadOnly] = proxy(PeerVpc, request)
            def unpeerVpc(request: model.UnpeerVpcRequest): IO[AwsError, model.UnpeerVpcResponse.ReadOnly] = proxy(UnpeerVpc, request)
            def getActiveNames(request: model.GetActiveNamesRequest): IO[AwsError, model.GetActiveNamesResponse.ReadOnly] = proxy(GetActiveNames, request)
            def getAutoSnapshots(request: model.GetAutoSnapshotsRequest): IO[AwsError, model.GetAutoSnapshotsResponse.ReadOnly] = proxy(GetAutoSnapshots, request)
            def startRelationalDatabase(request: model.StartRelationalDatabaseRequest): IO[AwsError, model.StartRelationalDatabaseResponse.ReadOnly] = proxy(StartRelationalDatabase, request)
            def createInstanceSnapshot(request: model.CreateInstanceSnapshotRequest): IO[AwsError, model.CreateInstanceSnapshotResponse.ReadOnly] = proxy(CreateInstanceSnapshot, request)
            def updateDomainEntry(request: model.UpdateDomainEntryRequest): IO[AwsError, model.UpdateDomainEntryResponse.ReadOnly] = proxy(UpdateDomainEntry, request)
            def rebootInstance(request: model.RebootInstanceRequest): IO[AwsError, model.RebootInstanceResponse.ReadOnly] = proxy(RebootInstance, request)
            def createContactMethod(request: model.CreateContactMethodRequest): IO[AwsError, model.CreateContactMethodResponse.ReadOnly] = proxy(CreateContactMethod, request)
            def getDiskSnapshots(request: model.GetDiskSnapshotsRequest): IO[AwsError, model.GetDiskSnapshotsResponse.ReadOnly] = proxy(GetDiskSnapshots, request)
            def getContainerLog(request: model.GetContainerLogRequest): IO[AwsError, model.GetContainerLogResponse.ReadOnly] = proxy(GetContainerLog, request)
            def getContainerServiceDeployments(request: model.GetContainerServiceDeploymentsRequest): IO[AwsError, model.GetContainerServiceDeploymentsResponse.ReadOnly] = proxy(GetContainerServiceDeployments, request)
            def createDomain(request: model.CreateDomainRequest): IO[AwsError, model.CreateDomainResponse.ReadOnly] = proxy(CreateDomain, request)
            def createContainerService(request: model.CreateContainerServiceRequest): IO[AwsError, model.CreateContainerServiceResponse.ReadOnly] = proxy(CreateContainerService, request)
            def isVpcPeered(request: model.IsVpcPeeredRequest): IO[AwsError, model.IsVpcPeeredResponse.ReadOnly] = proxy(IsVpcPeered, request)
            def deleteAutoSnapshot(request: model.DeleteAutoSnapshotRequest): IO[AwsError, model.DeleteAutoSnapshotResponse.ReadOnly] = proxy(DeleteAutoSnapshot, request)
            def createContainerServiceRegistryLogin(request: model.CreateContainerServiceRegistryLoginRequest): IO[AwsError, model.CreateContainerServiceRegistryLoginResponse.ReadOnly] = proxy(CreateContainerServiceRegistryLogin, request)
            def getDisk(request: model.GetDiskRequest): IO[AwsError, model.GetDiskResponse.ReadOnly] = proxy(GetDisk, request)
            def enableAddOn(request: model.EnableAddOnRequest): IO[AwsError, model.EnableAddOnResponse.ReadOnly] = proxy(EnableAddOn, request)
            def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = proxy(UntagResource, request)
            def createLoadBalancerTlsCertificate(request: model.CreateLoadBalancerTlsCertificateRequest): IO[AwsError, model.CreateLoadBalancerTlsCertificateResponse.ReadOnly] = proxy(CreateLoadBalancerTlsCertificate, request)
            def getStaticIp(request: model.GetStaticIpRequest): IO[AwsError, model.GetStaticIpResponse.ReadOnly] = proxy(GetStaticIp, request)
            def attachStaticIp(request: model.AttachStaticIpRequest): IO[AwsError, model.AttachStaticIpResponse.ReadOnly] = proxy(AttachStaticIp, request)
            def importKeyPair(request: model.ImportKeyPairRequest): IO[AwsError, model.ImportKeyPairResponse.ReadOnly] = proxy(ImportKeyPair, request)
            def getDisks(request: model.GetDisksRequest): IO[AwsError, model.GetDisksResponse.ReadOnly] = proxy(GetDisks, request)
            def downloadDefaultKeyPair(request: model.DownloadDefaultKeyPairRequest): IO[AwsError, model.DownloadDefaultKeyPairResponse.ReadOnly] = proxy(DownloadDefaultKeyPair, request)
            def getExportSnapshotRecords(request: model.GetExportSnapshotRecordsRequest): IO[AwsError, model.GetExportSnapshotRecordsResponse.ReadOnly] = proxy(GetExportSnapshotRecords, request)
            def createKeyPair(request: model.CreateKeyPairRequest): IO[AwsError, model.CreateKeyPairResponse.ReadOnly] = proxy(CreateKeyPair, request)
            def getBundles(request: model.GetBundlesRequest): IO[AwsError, model.GetBundlesResponse.ReadOnly] = proxy(GetBundles, request)
            def registerContainerImage(request: model.RegisterContainerImageRequest): IO[AwsError, model.RegisterContainerImageResponse.ReadOnly] = proxy(RegisterContainerImage, request)
            def startInstance(request: model.StartInstanceRequest): IO[AwsError, model.StartInstanceResponse.ReadOnly] = proxy(StartInstance, request)
            def getInstancePortStates(request: model.GetInstancePortStatesRequest): IO[AwsError, model.GetInstancePortStatesResponse.ReadOnly] = proxy(GetInstancePortStates, request)
            def deleteDisk(request: model.DeleteDiskRequest): IO[AwsError, model.DeleteDiskResponse.ReadOnly] = proxy(DeleteDisk, request)
            def getBlueprints(request: model.GetBlueprintsRequest): IO[AwsError, model.GetBlueprintsResponse.ReadOnly] = proxy(GetBlueprints, request)
            def deleteAlarm(request: model.DeleteAlarmRequest): IO[AwsError, model.DeleteAlarmResponse.ReadOnly] = proxy(DeleteAlarm, request)
            def createRelationalDatabaseSnapshot(request: model.CreateRelationalDatabaseSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseSnapshotResponse.ReadOnly] = proxy(CreateRelationalDatabaseSnapshot, request)
            def getContainerServiceMetricData(request: model.GetContainerServiceMetricDataRequest): IO[AwsError, model.GetContainerServiceMetricDataResponse.ReadOnly] = proxy(GetContainerServiceMetricData, request)
            def getRelationalDatabaseLogStreams(request: model.GetRelationalDatabaseLogStreamsRequest): IO[AwsError, model.GetRelationalDatabaseLogStreamsResponse.ReadOnly] = proxy(GetRelationalDatabaseLogStreams, request)
            def updateRelationalDatabaseParameters(request: model.UpdateRelationalDatabaseParametersRequest): IO[AwsError, model.UpdateRelationalDatabaseParametersResponse.ReadOnly] = proxy(UpdateRelationalDatabaseParameters, request)
            def createContainerServiceDeployment(request: model.CreateContainerServiceDeploymentRequest): IO[AwsError, model.CreateContainerServiceDeploymentResponse.ReadOnly] = proxy(CreateContainerServiceDeployment, request)
            def getDistributionLatestCacheReset(request: model.GetDistributionLatestCacheResetRequest): IO[AwsError, model.GetDistributionLatestCacheResetResponse.ReadOnly] = proxy(GetDistributionLatestCacheReset, request)
            def updateDistributionBundle(request: model.UpdateDistributionBundleRequest): IO[AwsError, model.UpdateDistributionBundleResponse.ReadOnly] = proxy(UpdateDistributionBundle, request)
            def deleteKeyPair(request: model.DeleteKeyPairRequest): IO[AwsError, model.DeleteKeyPairResponse.ReadOnly] = proxy(DeleteKeyPair, request)
            def getStaticIps(request: model.GetStaticIpsRequest): IO[AwsError, model.GetStaticIpsResponse.ReadOnly] = proxy(GetStaticIps, request)
            def createRelationalDatabase(request: model.CreateRelationalDatabaseRequest): IO[AwsError, model.CreateRelationalDatabaseResponse.ReadOnly] = proxy(CreateRelationalDatabase, request)
            def getCertificates(request: model.GetCertificatesRequest): IO[AwsError, model.GetCertificatesResponse.ReadOnly] = proxy(GetCertificates, request)
            def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = proxy(TagResource, request)
            def deleteDomain(request: model.DeleteDomainRequest): IO[AwsError, model.DeleteDomainResponse.ReadOnly] = proxy(DeleteDomain, request)
            def getRelationalDatabaseSnapshots(request: model.GetRelationalDatabaseSnapshotsRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotsResponse.ReadOnly] = proxy(GetRelationalDatabaseSnapshots, request)
            def createInstancesFromSnapshot(request: model.CreateInstancesFromSnapshotRequest): IO[AwsError, model.CreateInstancesFromSnapshotResponse.ReadOnly] = proxy(CreateInstancesFromSnapshot, request)
            def exportSnapshot(request: model.ExportSnapshotRequest): IO[AwsError, model.ExportSnapshotResponse.ReadOnly] = proxy(ExportSnapshot, request)
            def attachDisk(request: model.AttachDiskRequest): IO[AwsError, model.AttachDiskResponse.ReadOnly] = proxy(AttachDisk, request)
            def setIpAddressType(request: model.SetIpAddressTypeRequest): IO[AwsError, model.SetIpAddressTypeResponse.ReadOnly] = proxy(SetIpAddressType, request)
            def getRegions(request: model.GetRegionsRequest): IO[AwsError, model.GetRegionsResponse.ReadOnly] = proxy(GetRegions, request)
            def getRelationalDatabaseMetricData(request: model.GetRelationalDatabaseMetricDataRequest): IO[AwsError, model.GetRelationalDatabaseMetricDataResponse.ReadOnly] = proxy(GetRelationalDatabaseMetricData, request)
            def getOperation(request: model.GetOperationRequest): IO[AwsError, model.GetOperationResponse.ReadOnly] = proxy(GetOperation, request)
            def stopInstance(request: model.StopInstanceRequest): IO[AwsError, model.StopInstanceResponse.ReadOnly] = proxy(StopInstance, request)
            def getDistributionMetricData(request: model.GetDistributionMetricDataRequest): IO[AwsError, model.GetDistributionMetricDataResponse.ReadOnly] = proxy(GetDistributionMetricData, request)
            def getKeyPairs(request: model.GetKeyPairsRequest): IO[AwsError, model.GetKeyPairsResponse.ReadOnly] = proxy(GetKeyPairs, request)
            def disableAddOn(request: model.DisableAddOnRequest): IO[AwsError, model.DisableAddOnResponse.ReadOnly] = proxy(DisableAddOn, request)
            def createInstances(request: model.CreateInstancesRequest): IO[AwsError, model.CreateInstancesResponse.ReadOnly] = proxy(CreateInstances, request)
            def createLoadBalancer(request: model.CreateLoadBalancerRequest): IO[AwsError, model.CreateLoadBalancerResponse.ReadOnly] = proxy(CreateLoadBalancer, request)
            def getRelationalDatabaseBlueprints(request: model.GetRelationalDatabaseBlueprintsRequest): IO[AwsError, model.GetRelationalDatabaseBlueprintsResponse.ReadOnly] = proxy(GetRelationalDatabaseBlueprints, request)
            def detachCertificateFromDistribution(request: model.DetachCertificateFromDistributionRequest): IO[AwsError, model.DetachCertificateFromDistributionResponse.ReadOnly] = proxy(DetachCertificateFromDistribution, request)
            def getRelationalDatabaseMasterUserPassword(request: model.GetRelationalDatabaseMasterUserPasswordRequest): IO[AwsError, model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly] = proxy(GetRelationalDatabaseMasterUserPassword, request)
            def updateContainerService(request: model.UpdateContainerServiceRequest): IO[AwsError, model.UpdateContainerServiceResponse.ReadOnly] = proxy(UpdateContainerService, request)
            def getContainerServicePowers(request: model.GetContainerServicePowersRequest): IO[AwsError, model.GetContainerServicePowersResponse.ReadOnly] = proxy(GetContainerServicePowers, request)
            def getRelationalDatabase(request: model.GetRelationalDatabaseRequest): IO[AwsError, model.GetRelationalDatabaseResponse.ReadOnly] = proxy(GetRelationalDatabase, request)
            def getCloudFormationStackRecords(request: model.GetCloudFormationStackRecordsRequest): IO[AwsError, model.GetCloudFormationStackRecordsResponse.ReadOnly] = proxy(GetCloudFormationStackRecords, request)
            def updateDistribution(request: model.UpdateDistributionRequest): IO[AwsError, model.UpdateDistributionResponse.ReadOnly] = proxy(UpdateDistribution, request)
            def deleteDistribution(request: model.DeleteDistributionRequest): IO[AwsError, model.DeleteDistributionResponse.ReadOnly] = proxy(DeleteDistribution, request)
            def deleteContainerImage(request: model.DeleteContainerImageRequest): IO[AwsError, model.DeleteContainerImageResponse.ReadOnly] = proxy(DeleteContainerImage, request)
            def createDistribution(request: model.CreateDistributionRequest): IO[AwsError, model.CreateDistributionResponse.ReadOnly] = proxy(CreateDistribution, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Lightsail] = customized(identity)
  def customized(customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Lightsail] = managed(customization).toLayer
  def managed(customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Lightsail.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = LightsailAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[LightsailAsyncClient, LightsailAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[LightsailAsyncClient, LightsailAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new LightsailImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class LightsailImpl[R](override val api: LightsailAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Lightsail.Service with AwsServiceBase[R, LightsailImpl] {
    override val serviceName: String = "Lightsail"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): LightsailImpl[R1] = new LightsailImpl(api, newAspect, r)
    def putInstancePublicPorts(request: model.PutInstancePublicPortsRequest): IO[AwsError, model.PutInstancePublicPortsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest, software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse]("putInstancePublicPorts", api.putInstancePublicPorts)(request.buildAwsValue()).map(model.PutInstancePublicPortsResponse.wrap).provide(r)
    def resetDistributionCache(request: model.ResetDistributionCacheRequest): IO[AwsError, model.ResetDistributionCacheResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest, software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse]("resetDistributionCache", api.resetDistributionCache)(request.buildAwsValue()).map(model.ResetDistributionCacheResponse.wrap).provide(r)
    def getRelationalDatabaseSnapshot(request: model.GetRelationalDatabaseSnapshotRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse]("getRelationalDatabaseSnapshot", api.getRelationalDatabaseSnapshot)(request.buildAwsValue()).map(model.GetRelationalDatabaseSnapshotResponse.wrap).provide(r)
    def getKeyPair(request: model.GetKeyPairRequest): IO[AwsError, model.GetKeyPairResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest, software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse]("getKeyPair", api.getKeyPair)(request.buildAwsValue()).map(model.GetKeyPairResponse.wrap).provide(r)
    def getInstanceAccessDetails(request: model.GetInstanceAccessDetailsRequest): IO[AwsError, model.GetInstanceAccessDetailsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse]("getInstanceAccessDetails", api.getInstanceAccessDetails)(request.buildAwsValue()).map(model.GetInstanceAccessDetailsResponse.wrap).provide(r)
    def deleteLoadBalancerTlsCertificate(request: model.DeleteLoadBalancerTlsCertificateRequest): IO[AwsError, model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest, software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse]("deleteLoadBalancerTlsCertificate", api.deleteLoadBalancerTlsCertificate)(request.buildAwsValue()).map(model.DeleteLoadBalancerTlsCertificateResponse.wrap).provide(r)
    def createDiskSnapshot(request: model.CreateDiskSnapshotRequest): IO[AwsError, model.CreateDiskSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse]("createDiskSnapshot", api.createDiskSnapshot)(request.buildAwsValue()).map(model.CreateDiskSnapshotResponse.wrap).provide(r)
    def deleteRelationalDatabase(request: model.DeleteRelationalDatabaseRequest): IO[AwsError, model.DeleteRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse]("deleteRelationalDatabase", api.deleteRelationalDatabase)(request.buildAwsValue()).map(model.DeleteRelationalDatabaseResponse.wrap).provide(r)
    def releaseStaticIp(request: model.ReleaseStaticIpRequest): IO[AwsError, model.ReleaseStaticIpResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest, software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse]("releaseStaticIp", api.releaseStaticIp)(request.buildAwsValue()).map(model.ReleaseStaticIpResponse.wrap).provide(r)
    def updateLoadBalancerAttribute(request: model.UpdateLoadBalancerAttributeRequest): IO[AwsError, model.UpdateLoadBalancerAttributeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest, software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse]("updateLoadBalancerAttribute", api.updateLoadBalancerAttribute)(request.buildAwsValue()).map(model.UpdateLoadBalancerAttributeResponse.wrap).provide(r)
    def testAlarm(request: model.TestAlarmRequest): IO[AwsError, model.TestAlarmResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.TestAlarmRequest, software.amazon.awssdk.services.lightsail.model.TestAlarmResponse]("testAlarm", api.testAlarm)(request.buildAwsValue()).map(model.TestAlarmResponse.wrap).provide(r)
    def closeInstancePublicPorts(request: model.CloseInstancePublicPortsRequest): IO[AwsError, model.CloseInstancePublicPortsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest, software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse]("closeInstancePublicPorts", api.closeInstancePublicPorts)(request.buildAwsValue()).map(model.CloseInstancePublicPortsResponse.wrap).provide(r)
    def deleteContactMethod(request: model.DeleteContactMethodRequest): IO[AwsError, model.DeleteContactMethodResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest, software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse]("deleteContactMethod", api.deleteContactMethod)(request.buildAwsValue()).map(model.DeleteContactMethodResponse.wrap).provide(r)
    def deleteDiskSnapshot(request: model.DeleteDiskSnapshotRequest): IO[AwsError, model.DeleteDiskSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest, software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse]("deleteDiskSnapshot", api.deleteDiskSnapshot)(request.buildAwsValue()).map(model.DeleteDiskSnapshotResponse.wrap).provide(r)
    def putAlarm(request: model.PutAlarmRequest): IO[AwsError, model.PutAlarmResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.PutAlarmRequest, software.amazon.awssdk.services.lightsail.model.PutAlarmResponse]("putAlarm", api.putAlarm)(request.buildAwsValue()).map(model.PutAlarmResponse.wrap).provide(r)
    def getInstances(request: model.GetInstancesRequest): IO[AwsError, model.GetInstancesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstancesRequest, software.amazon.awssdk.services.lightsail.model.GetInstancesResponse]("getInstances", api.getInstances)(request.buildAwsValue()).map(model.GetInstancesResponse.wrap).provide(r)
    def createCertificate(request: model.CreateCertificateRequest): IO[AwsError, model.CreateCertificateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest, software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse]("createCertificate", api.createCertificate)(request.buildAwsValue()).map(model.CreateCertificateResponse.wrap).provide(r)
    def getRelationalDatabaseLogEvents(request: model.GetRelationalDatabaseLogEventsRequest): IO[AwsError, model.GetRelationalDatabaseLogEventsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse]("getRelationalDatabaseLogEvents", api.getRelationalDatabaseLogEvents)(request.buildAwsValue()).map(model.GetRelationalDatabaseLogEventsResponse.wrap).provide(r)
    def deleteKnownHostKeys(request: model.DeleteKnownHostKeysRequest): IO[AwsError, model.DeleteKnownHostKeysResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest, software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse]("deleteKnownHostKeys", api.deleteKnownHostKeys)(request.buildAwsValue()).map(model.DeleteKnownHostKeysResponse.wrap).provide(r)
    def rebootRelationalDatabase(request: model.RebootRelationalDatabaseRequest): IO[AwsError, model.RebootRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse]("rebootRelationalDatabase", api.rebootRelationalDatabase)(request.buildAwsValue()).map(model.RebootRelationalDatabaseResponse.wrap).provide(r)
    def createCloudFormationStack(request: model.CreateCloudFormationStackRequest): IO[AwsError, model.CreateCloudFormationStackResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest, software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse]("createCloudFormationStack", api.createCloudFormationStack)(request.buildAwsValue()).map(model.CreateCloudFormationStackResponse.wrap).provide(r)
    def detachDisk(request: model.DetachDiskRequest): IO[AwsError, model.DetachDiskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DetachDiskRequest, software.amazon.awssdk.services.lightsail.model.DetachDiskResponse]("detachDisk", api.detachDisk)(request.buildAwsValue()).map(model.DetachDiskResponse.wrap).provide(r)
    def allocateStaticIp(request: model.AllocateStaticIpRequest): IO[AwsError, model.AllocateStaticIpResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest, software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse]("allocateStaticIp", api.allocateStaticIp)(request.buildAwsValue()).map(model.AllocateStaticIpResponse.wrap).provide(r)
    def getRelationalDatabaseEvents(request: model.GetRelationalDatabaseEventsRequest): IO[AwsError, model.GetRelationalDatabaseEventsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse]("getRelationalDatabaseEvents", api.getRelationalDatabaseEvents)(request.buildAwsValue()).map(model.GetRelationalDatabaseEventsResponse.wrap).provide(r)
    def getOperations(request: model.GetOperationsRequest): IO[AwsError, model.GetOperationsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetOperationsRequest, software.amazon.awssdk.services.lightsail.model.GetOperationsResponse]("getOperations", api.getOperations)(request.buildAwsValue()).map(model.GetOperationsResponse.wrap).provide(r)
    def getInstanceState(request: model.GetInstanceStateRequest): IO[AwsError, model.GetInstanceStateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse]("getInstanceState", api.getInstanceState)(request.buildAwsValue()).map(model.GetInstanceStateResponse.wrap).provide(r)
    def getDomains(request: model.GetDomainsRequest): IO[AwsError, model.GetDomainsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDomainsRequest, software.amazon.awssdk.services.lightsail.model.GetDomainsResponse]("getDomains", api.getDomains)(request.buildAwsValue()).map(model.GetDomainsResponse.wrap).provide(r)
    def getLoadBalancers(request: model.GetLoadBalancersRequest): IO[AwsError, model.GetLoadBalancersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest, software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse]("getLoadBalancers", api.getLoadBalancers)(request.buildAwsValue()).map(model.GetLoadBalancersResponse.wrap).provide(r)
    def getContainerServices(request: model.GetContainerServicesRequest): IO[AwsError, model.GetContainerServicesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest, software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse]("getContainerServices", api.getContainerServices)(request.buildAwsValue()).map(model.GetContainerServicesResponse.wrap).provide(r)
    def getLoadBalancerTlsCertificates(request: model.GetLoadBalancerTlsCertificatesRequest): IO[AwsError, model.GetLoadBalancerTlsCertificatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest, software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse]("getLoadBalancerTlsCertificates", api.getLoadBalancerTlsCertificates)(request.buildAwsValue()).map(model.GetLoadBalancerTlsCertificatesResponse.wrap).provide(r)
    def createRelationalDatabaseFromSnapshot(request: model.CreateRelationalDatabaseFromSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse]("createRelationalDatabaseFromSnapshot", api.createRelationalDatabaseFromSnapshot)(request.buildAwsValue()).map(model.CreateRelationalDatabaseFromSnapshotResponse.wrap).provide(r)
    def getInstanceSnapshot(request: model.GetInstanceSnapshotRequest): IO[AwsError, model.GetInstanceSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse]("getInstanceSnapshot", api.getInstanceSnapshot)(request.buildAwsValue()).map(model.GetInstanceSnapshotResponse.wrap).provide(r)
    def deleteContainerService(request: model.DeleteContainerServiceRequest): IO[AwsError, model.DeleteContainerServiceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest, software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse]("deleteContainerService", api.deleteContainerService)(request.buildAwsValue()).map(model.DeleteContainerServiceResponse.wrap).provide(r)
    def getContainerAPIMetadata(request: model.GetContainerApiMetadataRequest): IO[AwsError, model.GetContainerApiMetadataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest, software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse]("getContainerAPIMetadata", api.getContainerAPIMetadata)(request.buildAwsValue()).map(model.GetContainerApiMetadataResponse.wrap).provide(r)
    def getDiskSnapshot(request: model.GetDiskSnapshotRequest): IO[AwsError, model.GetDiskSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest, software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse]("getDiskSnapshot", api.getDiskSnapshot)(request.buildAwsValue()).map(model.GetDiskSnapshotResponse.wrap).provide(r)
    def detachStaticIp(request: model.DetachStaticIpRequest): IO[AwsError, model.DetachStaticIpResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest, software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse]("detachStaticIp", api.detachStaticIp)(request.buildAwsValue()).map(model.DetachStaticIpResponse.wrap).provide(r)
    def createDisk(request: model.CreateDiskRequest): IO[AwsError, model.CreateDiskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDiskRequest, software.amazon.awssdk.services.lightsail.model.CreateDiskResponse]("createDisk", api.createDisk)(request.buildAwsValue()).map(model.CreateDiskResponse.wrap).provide(r)
    def getContainerImages(request: model.GetContainerImagesRequest): IO[AwsError, model.GetContainerImagesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest, software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse]("getContainerImages", api.getContainerImages)(request.buildAwsValue()).map(model.GetContainerImagesResponse.wrap).provide(r)
    def createDomainEntry(request: model.CreateDomainEntryRequest): IO[AwsError, model.CreateDomainEntryResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest, software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse]("createDomainEntry", api.createDomainEntry)(request.buildAwsValue()).map(model.CreateDomainEntryResponse.wrap).provide(r)
    def sendContactMethodVerification(request: model.SendContactMethodVerificationRequest): IO[AwsError, model.SendContactMethodVerificationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest, software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse]("sendContactMethodVerification", api.sendContactMethodVerification)(request.buildAwsValue()).map(model.SendContactMethodVerificationResponse.wrap).provide(r)
    def getDomain(request: model.GetDomainRequest): IO[AwsError, model.GetDomainResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDomainRequest, software.amazon.awssdk.services.lightsail.model.GetDomainResponse]("getDomain", api.getDomain)(request.buildAwsValue()).map(model.GetDomainResponse.wrap).provide(r)
    def deleteInstance(request: model.DeleteInstanceRequest): IO[AwsError, model.DeleteInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest, software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse]("deleteInstance", api.deleteInstance)(request.buildAwsValue()).map(model.DeleteInstanceResponse.wrap).provide(r)
    def copySnapshot(request: model.CopySnapshotRequest): IO[AwsError, model.CopySnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest, software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse]("copySnapshot", api.copySnapshot)(request.buildAwsValue()).map(model.CopySnapshotResponse.wrap).provide(r)
    def getContactMethods(request: model.GetContactMethodsRequest): IO[AwsError, model.GetContactMethodsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest, software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse]("getContactMethods", api.getContactMethods)(request.buildAwsValue()).map(model.GetContactMethodsResponse.wrap).provide(r)
    def getRelationalDatabaseBundles(request: model.GetRelationalDatabaseBundlesRequest): IO[AwsError, model.GetRelationalDatabaseBundlesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse]("getRelationalDatabaseBundles", api.getRelationalDatabaseBundles)(request.buildAwsValue()).map(model.GetRelationalDatabaseBundlesResponse.wrap).provide(r)
    def detachInstancesFromLoadBalancer(request: model.DetachInstancesFromLoadBalancerRequest): IO[AwsError, model.DetachInstancesFromLoadBalancerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest, software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse]("detachInstancesFromLoadBalancer", api.detachInstancesFromLoadBalancer)(request.buildAwsValue()).map(model.DetachInstancesFromLoadBalancerResponse.wrap).provide(r)
    def openInstancePublicPorts(request: model.OpenInstancePublicPortsRequest): IO[AwsError, model.OpenInstancePublicPortsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest, software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse]("openInstancePublicPorts", api.openInstancePublicPorts)(request.buildAwsValue()).map(model.OpenInstancePublicPortsResponse.wrap).provide(r)
    def getInstanceMetricData(request: model.GetInstanceMetricDataRequest): IO[AwsError, model.GetInstanceMetricDataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse]("getInstanceMetricData", api.getInstanceMetricData)(request.buildAwsValue()).map(model.GetInstanceMetricDataResponse.wrap).provide(r)
    def deleteRelationalDatabaseSnapshot(request: model.DeleteRelationalDatabaseSnapshotRequest): IO[AwsError, model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest, software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse]("deleteRelationalDatabaseSnapshot", api.deleteRelationalDatabaseSnapshot)(request.buildAwsValue()).map(model.DeleteRelationalDatabaseSnapshotResponse.wrap).provide(r)
    def attachInstancesToLoadBalancer(request: model.AttachInstancesToLoadBalancerRequest): IO[AwsError, model.AttachInstancesToLoadBalancerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest, software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse]("attachInstancesToLoadBalancer", api.attachInstancesToLoadBalancer)(request.buildAwsValue()).map(model.AttachInstancesToLoadBalancerResponse.wrap).provide(r)
    def getDistributionBundles(request: model.GetDistributionBundlesRequest): IO[AwsError, model.GetDistributionBundlesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest, software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse]("getDistributionBundles", api.getDistributionBundles)(request.buildAwsValue()).map(model.GetDistributionBundlesResponse.wrap).provide(r)
    def getRelationalDatabaseParameters(request: model.GetRelationalDatabaseParametersRequest): IO[AwsError, model.GetRelationalDatabaseParametersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse]("getRelationalDatabaseParameters", api.getRelationalDatabaseParameters)(request.buildAwsValue()).map(model.GetRelationalDatabaseParametersResponse.wrap).provide(r)
    def getAlarms(request: model.GetAlarmsRequest): IO[AwsError, model.GetAlarmsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest, software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse]("getAlarms", api.getAlarms)(request.buildAwsValue()).map(model.GetAlarmsResponse.wrap).provide(r)
    def deleteLoadBalancer(request: model.DeleteLoadBalancerRequest): IO[AwsError, model.DeleteLoadBalancerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest, software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse]("deleteLoadBalancer", api.deleteLoadBalancer)(request.buildAwsValue()).map(model.DeleteLoadBalancerResponse.wrap).provide(r)
    def getInstanceSnapshots(request: model.GetInstanceSnapshotsRequest): IO[AwsError, model.GetInstanceSnapshotsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse]("getInstanceSnapshots", api.getInstanceSnapshots)(request.buildAwsValue()).map(model.GetInstanceSnapshotsResponse.wrap).provide(r)
    def stopRelationalDatabase(request: model.StopRelationalDatabaseRequest): IO[AwsError, model.StopRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse]("stopRelationalDatabase", api.stopRelationalDatabase)(request.buildAwsValue()).map(model.StopRelationalDatabaseResponse.wrap).provide(r)
    def getLoadBalancerMetricData(request: model.GetLoadBalancerMetricDataRequest): IO[AwsError, model.GetLoadBalancerMetricDataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest, software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse]("getLoadBalancerMetricData", api.getLoadBalancerMetricData)(request.buildAwsValue()).map(model.GetLoadBalancerMetricDataResponse.wrap).provide(r)
    def attachCertificateToDistribution(request: model.AttachCertificateToDistributionRequest): IO[AwsError, model.AttachCertificateToDistributionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest, software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse]("attachCertificateToDistribution", api.attachCertificateToDistribution)(request.buildAwsValue()).map(model.AttachCertificateToDistributionResponse.wrap).provide(r)
    def deleteCertificate(request: model.DeleteCertificateRequest): IO[AwsError, model.DeleteCertificateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest, software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse]("deleteCertificate", api.deleteCertificate)(request.buildAwsValue()).map(model.DeleteCertificateResponse.wrap).provide(r)
    def getInstance(request: model.GetInstanceRequest): IO[AwsError, model.GetInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstanceRequest, software.amazon.awssdk.services.lightsail.model.GetInstanceResponse]("getInstance", api.getInstance)(request.buildAwsValue()).map(model.GetInstanceResponse.wrap).provide(r)
    def getDistributions(request: model.GetDistributionsRequest): IO[AwsError, model.GetDistributionsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest, software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse]("getDistributions", api.getDistributions)(request.buildAwsValue()).map(model.GetDistributionsResponse.wrap).provide(r)
    def getRelationalDatabases(request: model.GetRelationalDatabasesRequest): IO[AwsError, model.GetRelationalDatabasesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse]("getRelationalDatabases", api.getRelationalDatabases)(request.buildAwsValue()).map(model.GetRelationalDatabasesResponse.wrap).provide(r)
    def attachLoadBalancerTlsCertificate(request: model.AttachLoadBalancerTlsCertificateRequest): IO[AwsError, model.AttachLoadBalancerTlsCertificateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest, software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse]("attachLoadBalancerTlsCertificate", api.attachLoadBalancerTlsCertificate)(request.buildAwsValue()).map(model.AttachLoadBalancerTlsCertificateResponse.wrap).provide(r)
    def getOperationsForResource(request: model.GetOperationsForResourceRequest): IO[AwsError, model.GetOperationsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest, software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse]("getOperationsForResource", api.getOperationsForResource)(request.buildAwsValue()).map(model.GetOperationsForResourceResponse.wrap).provide(r)
    def createDiskFromSnapshot(request: model.CreateDiskFromSnapshotRequest): IO[AwsError, model.CreateDiskFromSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse]("createDiskFromSnapshot", api.createDiskFromSnapshot)(request.buildAwsValue()).map(model.CreateDiskFromSnapshotResponse.wrap).provide(r)
    def getLoadBalancer(request: model.GetLoadBalancerRequest): IO[AwsError, model.GetLoadBalancerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest, software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse]("getLoadBalancer", api.getLoadBalancer)(request.buildAwsValue()).map(model.GetLoadBalancerResponse.wrap).provide(r)
    def deleteInstanceSnapshot(request: model.DeleteInstanceSnapshotRequest): IO[AwsError, model.DeleteInstanceSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest, software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse]("deleteInstanceSnapshot", api.deleteInstanceSnapshot)(request.buildAwsValue()).map(model.DeleteInstanceSnapshotResponse.wrap).provide(r)
    def deleteDomainEntry(request: model.DeleteDomainEntryRequest): IO[AwsError, model.DeleteDomainEntryResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest, software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse]("deleteDomainEntry", api.deleteDomainEntry)(request.buildAwsValue()).map(model.DeleteDomainEntryResponse.wrap).provide(r)
    def updateRelationalDatabase(request: model.UpdateRelationalDatabaseRequest): IO[AwsError, model.UpdateRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse]("updateRelationalDatabase", api.updateRelationalDatabase)(request.buildAwsValue()).map(model.UpdateRelationalDatabaseResponse.wrap).provide(r)
    def peerVpc(request: model.PeerVpcRequest): IO[AwsError, model.PeerVpcResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.PeerVpcRequest, software.amazon.awssdk.services.lightsail.model.PeerVpcResponse]("peerVpc", api.peerVpc)(request.buildAwsValue()).map(model.PeerVpcResponse.wrap).provide(r)
    def unpeerVpc(request: model.UnpeerVpcRequest): IO[AwsError, model.UnpeerVpcResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest, software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse]("unpeerVpc", api.unpeerVpc)(request.buildAwsValue()).map(model.UnpeerVpcResponse.wrap).provide(r)
    def getActiveNames(request: model.GetActiveNamesRequest): IO[AwsError, model.GetActiveNamesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest, software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse]("getActiveNames", api.getActiveNames)(request.buildAwsValue()).map(model.GetActiveNamesResponse.wrap).provide(r)
    def getAutoSnapshots(request: model.GetAutoSnapshotsRequest): IO[AwsError, model.GetAutoSnapshotsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest, software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse]("getAutoSnapshots", api.getAutoSnapshots)(request.buildAwsValue()).map(model.GetAutoSnapshotsResponse.wrap).provide(r)
    def startRelationalDatabase(request: model.StartRelationalDatabaseRequest): IO[AwsError, model.StartRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse]("startRelationalDatabase", api.startRelationalDatabase)(request.buildAwsValue()).map(model.StartRelationalDatabaseResponse.wrap).provide(r)
    def createInstanceSnapshot(request: model.CreateInstanceSnapshotRequest): IO[AwsError, model.CreateInstanceSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse]("createInstanceSnapshot", api.createInstanceSnapshot)(request.buildAwsValue()).map(model.CreateInstanceSnapshotResponse.wrap).provide(r)
    def updateDomainEntry(request: model.UpdateDomainEntryRequest): IO[AwsError, model.UpdateDomainEntryResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest, software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse]("updateDomainEntry", api.updateDomainEntry)(request.buildAwsValue()).map(model.UpdateDomainEntryResponse.wrap).provide(r)
    def rebootInstance(request: model.RebootInstanceRequest): IO[AwsError, model.RebootInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest, software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse]("rebootInstance", api.rebootInstance)(request.buildAwsValue()).map(model.RebootInstanceResponse.wrap).provide(r)
    def createContactMethod(request: model.CreateContactMethodRequest): IO[AwsError, model.CreateContactMethodResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest, software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse]("createContactMethod", api.createContactMethod)(request.buildAwsValue()).map(model.CreateContactMethodResponse.wrap).provide(r)
    def getDiskSnapshots(request: model.GetDiskSnapshotsRequest): IO[AwsError, model.GetDiskSnapshotsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest, software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse]("getDiskSnapshots", api.getDiskSnapshots)(request.buildAwsValue()).map(model.GetDiskSnapshotsResponse.wrap).provide(r)
    def getContainerLog(request: model.GetContainerLogRequest): IO[AwsError, model.GetContainerLogResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest, software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse]("getContainerLog", api.getContainerLog)(request.buildAwsValue()).map(model.GetContainerLogResponse.wrap).provide(r)
    def getContainerServiceDeployments(request: model.GetContainerServiceDeploymentsRequest): IO[AwsError, model.GetContainerServiceDeploymentsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest, software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse]("getContainerServiceDeployments", api.getContainerServiceDeployments)(request.buildAwsValue()).map(model.GetContainerServiceDeploymentsResponse.wrap).provide(r)
    def createDomain(request: model.CreateDomainRequest): IO[AwsError, model.CreateDomainResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDomainRequest, software.amazon.awssdk.services.lightsail.model.CreateDomainResponse]("createDomain", api.createDomain)(request.buildAwsValue()).map(model.CreateDomainResponse.wrap).provide(r)
    def createContainerService(request: model.CreateContainerServiceRequest): IO[AwsError, model.CreateContainerServiceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest, software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse]("createContainerService", api.createContainerService)(request.buildAwsValue()).map(model.CreateContainerServiceResponse.wrap).provide(r)
    def isVpcPeered(request: model.IsVpcPeeredRequest): IO[AwsError, model.IsVpcPeeredResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest, software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse]("isVpcPeered", api.isVpcPeered)(request.buildAwsValue()).map(model.IsVpcPeeredResponse.wrap).provide(r)
    def deleteAutoSnapshot(request: model.DeleteAutoSnapshotRequest): IO[AwsError, model.DeleteAutoSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest, software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse]("deleteAutoSnapshot", api.deleteAutoSnapshot)(request.buildAwsValue()).map(model.DeleteAutoSnapshotResponse.wrap).provide(r)
    def createContainerServiceRegistryLogin(request: model.CreateContainerServiceRegistryLoginRequest): IO[AwsError, model.CreateContainerServiceRegistryLoginResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest, software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse]("createContainerServiceRegistryLogin", api.createContainerServiceRegistryLogin)(request.buildAwsValue()).map(model.CreateContainerServiceRegistryLoginResponse.wrap).provide(r)
    def getDisk(request: model.GetDiskRequest): IO[AwsError, model.GetDiskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDiskRequest, software.amazon.awssdk.services.lightsail.model.GetDiskResponse]("getDisk", api.getDisk)(request.buildAwsValue()).map(model.GetDiskResponse.wrap).provide(r)
    def enableAddOn(request: model.EnableAddOnRequest): IO[AwsError, model.EnableAddOnResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest, software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse]("enableAddOn", api.enableAddOn)(request.buildAwsValue()).map(model.EnableAddOnResponse.wrap).provide(r)
    def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UntagResourceRequest, software.amazon.awssdk.services.lightsail.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).map(model.UntagResourceResponse.wrap).provide(r)
    def createLoadBalancerTlsCertificate(request: model.CreateLoadBalancerTlsCertificateRequest): IO[AwsError, model.CreateLoadBalancerTlsCertificateResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest, software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse]("createLoadBalancerTlsCertificate", api.createLoadBalancerTlsCertificate)(request.buildAwsValue()).map(model.CreateLoadBalancerTlsCertificateResponse.wrap).provide(r)
    def getStaticIp(request: model.GetStaticIpRequest): IO[AwsError, model.GetStaticIpResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest, software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse]("getStaticIp", api.getStaticIp)(request.buildAwsValue()).map(model.GetStaticIpResponse.wrap).provide(r)
    def attachStaticIp(request: model.AttachStaticIpRequest): IO[AwsError, model.AttachStaticIpResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest, software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse]("attachStaticIp", api.attachStaticIp)(request.buildAwsValue()).map(model.AttachStaticIpResponse.wrap).provide(r)
    def importKeyPair(request: model.ImportKeyPairRequest): IO[AwsError, model.ImportKeyPairResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest, software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse]("importKeyPair", api.importKeyPair)(request.buildAwsValue()).map(model.ImportKeyPairResponse.wrap).provide(r)
    def getDisks(request: model.GetDisksRequest): IO[AwsError, model.GetDisksResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDisksRequest, software.amazon.awssdk.services.lightsail.model.GetDisksResponse]("getDisks", api.getDisks)(request.buildAwsValue()).map(model.GetDisksResponse.wrap).provide(r)
    def downloadDefaultKeyPair(request: model.DownloadDefaultKeyPairRequest): IO[AwsError, model.DownloadDefaultKeyPairResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest, software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse]("downloadDefaultKeyPair", api.downloadDefaultKeyPair)(request.buildAwsValue()).map(model.DownloadDefaultKeyPairResponse.wrap).provide(r)
    def getExportSnapshotRecords(request: model.GetExportSnapshotRecordsRequest): IO[AwsError, model.GetExportSnapshotRecordsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest, software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse]("getExportSnapshotRecords", api.getExportSnapshotRecords)(request.buildAwsValue()).map(model.GetExportSnapshotRecordsResponse.wrap).provide(r)
    def createKeyPair(request: model.CreateKeyPairRequest): IO[AwsError, model.CreateKeyPairResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest, software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse]("createKeyPair", api.createKeyPair)(request.buildAwsValue()).map(model.CreateKeyPairResponse.wrap).provide(r)
    def getBundles(request: model.GetBundlesRequest): IO[AwsError, model.GetBundlesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetBundlesRequest, software.amazon.awssdk.services.lightsail.model.GetBundlesResponse]("getBundles", api.getBundles)(request.buildAwsValue()).map(model.GetBundlesResponse.wrap).provide(r)
    def registerContainerImage(request: model.RegisterContainerImageRequest): IO[AwsError, model.RegisterContainerImageResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest, software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse]("registerContainerImage", api.registerContainerImage)(request.buildAwsValue()).map(model.RegisterContainerImageResponse.wrap).provide(r)
    def startInstance(request: model.StartInstanceRequest): IO[AwsError, model.StartInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.StartInstanceRequest, software.amazon.awssdk.services.lightsail.model.StartInstanceResponse]("startInstance", api.startInstance)(request.buildAwsValue()).map(model.StartInstanceResponse.wrap).provide(r)
    def getInstancePortStates(request: model.GetInstancePortStatesRequest): IO[AwsError, model.GetInstancePortStatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest, software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse]("getInstancePortStates", api.getInstancePortStates)(request.buildAwsValue()).map(model.GetInstancePortStatesResponse.wrap).provide(r)
    def deleteDisk(request: model.DeleteDiskRequest): IO[AwsError, model.DeleteDiskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest, software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse]("deleteDisk", api.deleteDisk)(request.buildAwsValue()).map(model.DeleteDiskResponse.wrap).provide(r)
    def getBlueprints(request: model.GetBlueprintsRequest): IO[AwsError, model.GetBlueprintsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest, software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse]("getBlueprints", api.getBlueprints)(request.buildAwsValue()).map(model.GetBlueprintsResponse.wrap).provide(r)
    def deleteAlarm(request: model.DeleteAlarmRequest): IO[AwsError, model.DeleteAlarmResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest, software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse]("deleteAlarm", api.deleteAlarm)(request.buildAwsValue()).map(model.DeleteAlarmResponse.wrap).provide(r)
    def createRelationalDatabaseSnapshot(request: model.CreateRelationalDatabaseSnapshotRequest): IO[AwsError, model.CreateRelationalDatabaseSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse]("createRelationalDatabaseSnapshot", api.createRelationalDatabaseSnapshot)(request.buildAwsValue()).map(model.CreateRelationalDatabaseSnapshotResponse.wrap).provide(r)
    def getContainerServiceMetricData(request: model.GetContainerServiceMetricDataRequest): IO[AwsError, model.GetContainerServiceMetricDataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest, software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse]("getContainerServiceMetricData", api.getContainerServiceMetricData)(request.buildAwsValue()).map(model.GetContainerServiceMetricDataResponse.wrap).provide(r)
    def getRelationalDatabaseLogStreams(request: model.GetRelationalDatabaseLogStreamsRequest): IO[AwsError, model.GetRelationalDatabaseLogStreamsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse]("getRelationalDatabaseLogStreams", api.getRelationalDatabaseLogStreams)(request.buildAwsValue()).map(model.GetRelationalDatabaseLogStreamsResponse.wrap).provide(r)
    def updateRelationalDatabaseParameters(request: model.UpdateRelationalDatabaseParametersRequest): IO[AwsError, model.UpdateRelationalDatabaseParametersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest, software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse]("updateRelationalDatabaseParameters", api.updateRelationalDatabaseParameters)(request.buildAwsValue()).map(model.UpdateRelationalDatabaseParametersResponse.wrap).provide(r)
    def createContainerServiceDeployment(request: model.CreateContainerServiceDeploymentRequest): IO[AwsError, model.CreateContainerServiceDeploymentResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest, software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse]("createContainerServiceDeployment", api.createContainerServiceDeployment)(request.buildAwsValue()).map(model.CreateContainerServiceDeploymentResponse.wrap).provide(r)
    def getDistributionLatestCacheReset(request: model.GetDistributionLatestCacheResetRequest): IO[AwsError, model.GetDistributionLatestCacheResetResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest, software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse]("getDistributionLatestCacheReset", api.getDistributionLatestCacheReset)(request.buildAwsValue()).map(model.GetDistributionLatestCacheResetResponse.wrap).provide(r)
    def updateDistributionBundle(request: model.UpdateDistributionBundleRequest): IO[AwsError, model.UpdateDistributionBundleResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest, software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse]("updateDistributionBundle", api.updateDistributionBundle)(request.buildAwsValue()).map(model.UpdateDistributionBundleResponse.wrap).provide(r)
    def deleteKeyPair(request: model.DeleteKeyPairRequest): IO[AwsError, model.DeleteKeyPairResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest, software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse]("deleteKeyPair", api.deleteKeyPair)(request.buildAwsValue()).map(model.DeleteKeyPairResponse.wrap).provide(r)
    def getStaticIps(request: model.GetStaticIpsRequest): IO[AwsError, model.GetStaticIpsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest, software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse]("getStaticIps", api.getStaticIps)(request.buildAwsValue()).map(model.GetStaticIpsResponse.wrap).provide(r)
    def createRelationalDatabase(request: model.CreateRelationalDatabaseRequest): IO[AwsError, model.CreateRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse]("createRelationalDatabase", api.createRelationalDatabase)(request.buildAwsValue()).map(model.CreateRelationalDatabaseResponse.wrap).provide(r)
    def getCertificates(request: model.GetCertificatesRequest): IO[AwsError, model.GetCertificatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest, software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse]("getCertificates", api.getCertificates)(request.buildAwsValue()).map(model.GetCertificatesResponse.wrap).provide(r)
    def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.TagResourceRequest, software.amazon.awssdk.services.lightsail.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).map(model.TagResourceResponse.wrap).provide(r)
    def deleteDomain(request: model.DeleteDomainRequest): IO[AwsError, model.DeleteDomainResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest, software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse]("deleteDomain", api.deleteDomain)(request.buildAwsValue()).map(model.DeleteDomainResponse.wrap).provide(r)
    def getRelationalDatabaseSnapshots(request: model.GetRelationalDatabaseSnapshotsRequest): IO[AwsError, model.GetRelationalDatabaseSnapshotsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse]("getRelationalDatabaseSnapshots", api.getRelationalDatabaseSnapshots)(request.buildAwsValue()).map(model.GetRelationalDatabaseSnapshotsResponse.wrap).provide(r)
    def createInstancesFromSnapshot(request: model.CreateInstancesFromSnapshotRequest): IO[AwsError, model.CreateInstancesFromSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest, software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse]("createInstancesFromSnapshot", api.createInstancesFromSnapshot)(request.buildAwsValue()).map(model.CreateInstancesFromSnapshotResponse.wrap).provide(r)
    def exportSnapshot(request: model.ExportSnapshotRequest): IO[AwsError, model.ExportSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest, software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse]("exportSnapshot", api.exportSnapshot)(request.buildAwsValue()).map(model.ExportSnapshotResponse.wrap).provide(r)
    def attachDisk(request: model.AttachDiskRequest): IO[AwsError, model.AttachDiskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.AttachDiskRequest, software.amazon.awssdk.services.lightsail.model.AttachDiskResponse]("attachDisk", api.attachDisk)(request.buildAwsValue()).map(model.AttachDiskResponse.wrap).provide(r)
    def setIpAddressType(request: model.SetIpAddressTypeRequest): IO[AwsError, model.SetIpAddressTypeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest, software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse]("setIpAddressType", api.setIpAddressType)(request.buildAwsValue()).map(model.SetIpAddressTypeResponse.wrap).provide(r)
    def getRegions(request: model.GetRegionsRequest): IO[AwsError, model.GetRegionsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRegionsRequest, software.amazon.awssdk.services.lightsail.model.GetRegionsResponse]("getRegions", api.getRegions)(request.buildAwsValue()).map(model.GetRegionsResponse.wrap).provide(r)
    def getRelationalDatabaseMetricData(request: model.GetRelationalDatabaseMetricDataRequest): IO[AwsError, model.GetRelationalDatabaseMetricDataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse]("getRelationalDatabaseMetricData", api.getRelationalDatabaseMetricData)(request.buildAwsValue()).map(model.GetRelationalDatabaseMetricDataResponse.wrap).provide(r)
    def getOperation(request: model.GetOperationRequest): IO[AwsError, model.GetOperationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetOperationRequest, software.amazon.awssdk.services.lightsail.model.GetOperationResponse]("getOperation", api.getOperation)(request.buildAwsValue()).map(model.GetOperationResponse.wrap).provide(r)
    def stopInstance(request: model.StopInstanceRequest): IO[AwsError, model.StopInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.StopInstanceRequest, software.amazon.awssdk.services.lightsail.model.StopInstanceResponse]("stopInstance", api.stopInstance)(request.buildAwsValue()).map(model.StopInstanceResponse.wrap).provide(r)
    def getDistributionMetricData(request: model.GetDistributionMetricDataRequest): IO[AwsError, model.GetDistributionMetricDataResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest, software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse]("getDistributionMetricData", api.getDistributionMetricData)(request.buildAwsValue()).map(model.GetDistributionMetricDataResponse.wrap).provide(r)
    def getKeyPairs(request: model.GetKeyPairsRequest): IO[AwsError, model.GetKeyPairsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest, software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse]("getKeyPairs", api.getKeyPairs)(request.buildAwsValue()).map(model.GetKeyPairsResponse.wrap).provide(r)
    def disableAddOn(request: model.DisableAddOnRequest): IO[AwsError, model.DisableAddOnResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest, software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse]("disableAddOn", api.disableAddOn)(request.buildAwsValue()).map(model.DisableAddOnResponse.wrap).provide(r)
    def createInstances(request: model.CreateInstancesRequest): IO[AwsError, model.CreateInstancesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest, software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse]("createInstances", api.createInstances)(request.buildAwsValue()).map(model.CreateInstancesResponse.wrap).provide(r)
    def createLoadBalancer(request: model.CreateLoadBalancerRequest): IO[AwsError, model.CreateLoadBalancerResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest, software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse]("createLoadBalancer", api.createLoadBalancer)(request.buildAwsValue()).map(model.CreateLoadBalancerResponse.wrap).provide(r)
    def getRelationalDatabaseBlueprints(request: model.GetRelationalDatabaseBlueprintsRequest): IO[AwsError, model.GetRelationalDatabaseBlueprintsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse]("getRelationalDatabaseBlueprints", api.getRelationalDatabaseBlueprints)(request.buildAwsValue()).map(model.GetRelationalDatabaseBlueprintsResponse.wrap).provide(r)
    def detachCertificateFromDistribution(request: model.DetachCertificateFromDistributionRequest): IO[AwsError, model.DetachCertificateFromDistributionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest, software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse]("detachCertificateFromDistribution", api.detachCertificateFromDistribution)(request.buildAwsValue()).map(model.DetachCertificateFromDistributionResponse.wrap).provide(r)
    def getRelationalDatabaseMasterUserPassword(request: model.GetRelationalDatabaseMasterUserPasswordRequest): IO[AwsError, model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse]("getRelationalDatabaseMasterUserPassword", api.getRelationalDatabaseMasterUserPassword)(request.buildAwsValue()).map(model.GetRelationalDatabaseMasterUserPasswordResponse.wrap).provide(r)
    def updateContainerService(request: model.UpdateContainerServiceRequest): IO[AwsError, model.UpdateContainerServiceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest, software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse]("updateContainerService", api.updateContainerService)(request.buildAwsValue()).map(model.UpdateContainerServiceResponse.wrap).provide(r)
    def getContainerServicePowers(request: model.GetContainerServicePowersRequest): IO[AwsError, model.GetContainerServicePowersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest, software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse]("getContainerServicePowers", api.getContainerServicePowers)(request.buildAwsValue()).map(model.GetContainerServicePowersResponse.wrap).provide(r)
    def getRelationalDatabase(request: model.GetRelationalDatabaseRequest): IO[AwsError, model.GetRelationalDatabaseResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest, software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse]("getRelationalDatabase", api.getRelationalDatabase)(request.buildAwsValue()).map(model.GetRelationalDatabaseResponse.wrap).provide(r)
    def getCloudFormationStackRecords(request: model.GetCloudFormationStackRecordsRequest): IO[AwsError, model.GetCloudFormationStackRecordsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest, software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse]("getCloudFormationStackRecords", api.getCloudFormationStackRecords)(request.buildAwsValue()).map(model.GetCloudFormationStackRecordsResponse.wrap).provide(r)
    def updateDistribution(request: model.UpdateDistributionRequest): IO[AwsError, model.UpdateDistributionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest, software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse]("updateDistribution", api.updateDistribution)(request.buildAwsValue()).map(model.UpdateDistributionResponse.wrap).provide(r)
    def deleteDistribution(request: model.DeleteDistributionRequest): IO[AwsError, model.DeleteDistributionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest, software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse]("deleteDistribution", api.deleteDistribution)(request.buildAwsValue()).map(model.DeleteDistributionResponse.wrap).provide(r)
    def deleteContainerImage(request: model.DeleteContainerImageRequest): IO[AwsError, model.DeleteContainerImageResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest, software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse]("deleteContainerImage", api.deleteContainerImage)(request.buildAwsValue()).map(model.DeleteContainerImageResponse.wrap).provide(r)
    def createDistribution(request: model.CreateDistributionRequest): IO[AwsError, model.CreateDistributionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest, software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse]("createDistribution", api.createDistribution)(request.buildAwsValue()).map(model.CreateDistributionResponse.wrap).provide(r)
  }
  def putInstancePublicPorts(request: model.PutInstancePublicPortsRequest): ZIO[Lightsail, AwsError, model.PutInstancePublicPortsResponse.ReadOnly] = ZIO.accessM(_.get.putInstancePublicPorts(request))
  def resetDistributionCache(request: model.ResetDistributionCacheRequest): ZIO[Lightsail, AwsError, model.ResetDistributionCacheResponse.ReadOnly] = ZIO.accessM(_.get.resetDistributionCache(request))
  def getRelationalDatabaseSnapshot(request: model.GetRelationalDatabaseSnapshotRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseSnapshot(request))
  def getKeyPair(request: model.GetKeyPairRequest): ZIO[Lightsail, AwsError, model.GetKeyPairResponse.ReadOnly] = ZIO.accessM(_.get.getKeyPair(request))
  def getInstanceAccessDetails(request: model.GetInstanceAccessDetailsRequest): ZIO[Lightsail, AwsError, model.GetInstanceAccessDetailsResponse.ReadOnly] = ZIO.accessM(_.get.getInstanceAccessDetails(request))
  def deleteLoadBalancerTlsCertificate(request: model.DeleteLoadBalancerTlsCertificateRequest): ZIO[Lightsail, AwsError, model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly] = ZIO.accessM(_.get.deleteLoadBalancerTlsCertificate(request))
  def createDiskSnapshot(request: model.CreateDiskSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateDiskSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createDiskSnapshot(request))
  def deleteRelationalDatabase(request: model.DeleteRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.DeleteRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.deleteRelationalDatabase(request))
  def releaseStaticIp(request: model.ReleaseStaticIpRequest): ZIO[Lightsail, AwsError, model.ReleaseStaticIpResponse.ReadOnly] = ZIO.accessM(_.get.releaseStaticIp(request))
  def updateLoadBalancerAttribute(request: model.UpdateLoadBalancerAttributeRequest): ZIO[Lightsail, AwsError, model.UpdateLoadBalancerAttributeResponse.ReadOnly] = ZIO.accessM(_.get.updateLoadBalancerAttribute(request))
  def testAlarm(request: model.TestAlarmRequest): ZIO[Lightsail, AwsError, model.TestAlarmResponse.ReadOnly] = ZIO.accessM(_.get.testAlarm(request))
  def closeInstancePublicPorts(request: model.CloseInstancePublicPortsRequest): ZIO[Lightsail, AwsError, model.CloseInstancePublicPortsResponse.ReadOnly] = ZIO.accessM(_.get.closeInstancePublicPorts(request))
  def deleteContactMethod(request: model.DeleteContactMethodRequest): ZIO[Lightsail, AwsError, model.DeleteContactMethodResponse.ReadOnly] = ZIO.accessM(_.get.deleteContactMethod(request))
  def deleteDiskSnapshot(request: model.DeleteDiskSnapshotRequest): ZIO[Lightsail, AwsError, model.DeleteDiskSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteDiskSnapshot(request))
  def putAlarm(request: model.PutAlarmRequest): ZIO[Lightsail, AwsError, model.PutAlarmResponse.ReadOnly] = ZIO.accessM(_.get.putAlarm(request))
  def getInstances(request: model.GetInstancesRequest): ZIO[Lightsail, AwsError, model.GetInstancesResponse.ReadOnly] = ZIO.accessM(_.get.getInstances(request))
  def createCertificate(request: model.CreateCertificateRequest): ZIO[Lightsail, AwsError, model.CreateCertificateResponse.ReadOnly] = ZIO.accessM(_.get.createCertificate(request))
  def getRelationalDatabaseLogEvents(request: model.GetRelationalDatabaseLogEventsRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseLogEventsResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseLogEvents(request))
  def deleteKnownHostKeys(request: model.DeleteKnownHostKeysRequest): ZIO[Lightsail, AwsError, model.DeleteKnownHostKeysResponse.ReadOnly] = ZIO.accessM(_.get.deleteKnownHostKeys(request))
  def rebootRelationalDatabase(request: model.RebootRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.RebootRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.rebootRelationalDatabase(request))
  def createCloudFormationStack(request: model.CreateCloudFormationStackRequest): ZIO[Lightsail, AwsError, model.CreateCloudFormationStackResponse.ReadOnly] = ZIO.accessM(_.get.createCloudFormationStack(request))
  def detachDisk(request: model.DetachDiskRequest): ZIO[Lightsail, AwsError, model.DetachDiskResponse.ReadOnly] = ZIO.accessM(_.get.detachDisk(request))
  def allocateStaticIp(request: model.AllocateStaticIpRequest): ZIO[Lightsail, AwsError, model.AllocateStaticIpResponse.ReadOnly] = ZIO.accessM(_.get.allocateStaticIp(request))
  def getRelationalDatabaseEvents(request: model.GetRelationalDatabaseEventsRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseEventsResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseEvents(request))
  def getOperations(request: model.GetOperationsRequest): ZIO[Lightsail, AwsError, model.GetOperationsResponse.ReadOnly] = ZIO.accessM(_.get.getOperations(request))
  def getInstanceState(request: model.GetInstanceStateRequest): ZIO[Lightsail, AwsError, model.GetInstanceStateResponse.ReadOnly] = ZIO.accessM(_.get.getInstanceState(request))
  def getDomains(request: model.GetDomainsRequest): ZIO[Lightsail, AwsError, model.GetDomainsResponse.ReadOnly] = ZIO.accessM(_.get.getDomains(request))
  def getLoadBalancers(request: model.GetLoadBalancersRequest): ZIO[Lightsail, AwsError, model.GetLoadBalancersResponse.ReadOnly] = ZIO.accessM(_.get.getLoadBalancers(request))
  def getContainerServices(request: model.GetContainerServicesRequest): ZIO[Lightsail, AwsError, model.GetContainerServicesResponse.ReadOnly] = ZIO.accessM(_.get.getContainerServices(request))
  def getLoadBalancerTlsCertificates(request: model.GetLoadBalancerTlsCertificatesRequest): ZIO[Lightsail, AwsError, model.GetLoadBalancerTlsCertificatesResponse.ReadOnly] = ZIO.accessM(_.get.getLoadBalancerTlsCertificates(request))
  def createRelationalDatabaseFromSnapshot(request: model.CreateRelationalDatabaseFromSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createRelationalDatabaseFromSnapshot(request))
  def getInstanceSnapshot(request: model.GetInstanceSnapshotRequest): ZIO[Lightsail, AwsError, model.GetInstanceSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.getInstanceSnapshot(request))
  def deleteContainerService(request: model.DeleteContainerServiceRequest): ZIO[Lightsail, AwsError, model.DeleteContainerServiceResponse.ReadOnly] = ZIO.accessM(_.get.deleteContainerService(request))
  def getContainerAPIMetadata(request: model.GetContainerApiMetadataRequest): ZIO[Lightsail, AwsError, model.GetContainerApiMetadataResponse.ReadOnly] = ZIO.accessM(_.get.getContainerAPIMetadata(request))
  def getDiskSnapshot(request: model.GetDiskSnapshotRequest): ZIO[Lightsail, AwsError, model.GetDiskSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.getDiskSnapshot(request))
  def detachStaticIp(request: model.DetachStaticIpRequest): ZIO[Lightsail, AwsError, model.DetachStaticIpResponse.ReadOnly] = ZIO.accessM(_.get.detachStaticIp(request))
  def createDisk(request: model.CreateDiskRequest): ZIO[Lightsail, AwsError, model.CreateDiskResponse.ReadOnly] = ZIO.accessM(_.get.createDisk(request))
  def getContainerImages(request: model.GetContainerImagesRequest): ZIO[Lightsail, AwsError, model.GetContainerImagesResponse.ReadOnly] = ZIO.accessM(_.get.getContainerImages(request))
  def createDomainEntry(request: model.CreateDomainEntryRequest): ZIO[Lightsail, AwsError, model.CreateDomainEntryResponse.ReadOnly] = ZIO.accessM(_.get.createDomainEntry(request))
  def sendContactMethodVerification(request: model.SendContactMethodVerificationRequest): ZIO[Lightsail, AwsError, model.SendContactMethodVerificationResponse.ReadOnly] = ZIO.accessM(_.get.sendContactMethodVerification(request))
  def getDomain(request: model.GetDomainRequest): ZIO[Lightsail, AwsError, model.GetDomainResponse.ReadOnly] = ZIO.accessM(_.get.getDomain(request))
  def deleteInstance(request: model.DeleteInstanceRequest): ZIO[Lightsail, AwsError, model.DeleteInstanceResponse.ReadOnly] = ZIO.accessM(_.get.deleteInstance(request))
  def copySnapshot(request: model.CopySnapshotRequest): ZIO[Lightsail, AwsError, model.CopySnapshotResponse.ReadOnly] = ZIO.accessM(_.get.copySnapshot(request))
  def getContactMethods(request: model.GetContactMethodsRequest): ZIO[Lightsail, AwsError, model.GetContactMethodsResponse.ReadOnly] = ZIO.accessM(_.get.getContactMethods(request))
  def getRelationalDatabaseBundles(request: model.GetRelationalDatabaseBundlesRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseBundlesResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseBundles(request))
  def detachInstancesFromLoadBalancer(request: model.DetachInstancesFromLoadBalancerRequest): ZIO[Lightsail, AwsError, model.DetachInstancesFromLoadBalancerResponse.ReadOnly] = ZIO.accessM(_.get.detachInstancesFromLoadBalancer(request))
  def openInstancePublicPorts(request: model.OpenInstancePublicPortsRequest): ZIO[Lightsail, AwsError, model.OpenInstancePublicPortsResponse.ReadOnly] = ZIO.accessM(_.get.openInstancePublicPorts(request))
  def getInstanceMetricData(request: model.GetInstanceMetricDataRequest): ZIO[Lightsail, AwsError, model.GetInstanceMetricDataResponse.ReadOnly] = ZIO.accessM(_.get.getInstanceMetricData(request))
  def deleteRelationalDatabaseSnapshot(request: model.DeleteRelationalDatabaseSnapshotRequest): ZIO[Lightsail, AwsError, model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteRelationalDatabaseSnapshot(request))
  def attachInstancesToLoadBalancer(request: model.AttachInstancesToLoadBalancerRequest): ZIO[Lightsail, AwsError, model.AttachInstancesToLoadBalancerResponse.ReadOnly] = ZIO.accessM(_.get.attachInstancesToLoadBalancer(request))
  def getDistributionBundles(request: model.GetDistributionBundlesRequest): ZIO[Lightsail, AwsError, model.GetDistributionBundlesResponse.ReadOnly] = ZIO.accessM(_.get.getDistributionBundles(request))
  def getRelationalDatabaseParameters(request: model.GetRelationalDatabaseParametersRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseParametersResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseParameters(request))
  def getAlarms(request: model.GetAlarmsRequest): ZIO[Lightsail, AwsError, model.GetAlarmsResponse.ReadOnly] = ZIO.accessM(_.get.getAlarms(request))
  def deleteLoadBalancer(request: model.DeleteLoadBalancerRequest): ZIO[Lightsail, AwsError, model.DeleteLoadBalancerResponse.ReadOnly] = ZIO.accessM(_.get.deleteLoadBalancer(request))
  def getInstanceSnapshots(request: model.GetInstanceSnapshotsRequest): ZIO[Lightsail, AwsError, model.GetInstanceSnapshotsResponse.ReadOnly] = ZIO.accessM(_.get.getInstanceSnapshots(request))
  def stopRelationalDatabase(request: model.StopRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.StopRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.stopRelationalDatabase(request))
  def getLoadBalancerMetricData(request: model.GetLoadBalancerMetricDataRequest): ZIO[Lightsail, AwsError, model.GetLoadBalancerMetricDataResponse.ReadOnly] = ZIO.accessM(_.get.getLoadBalancerMetricData(request))
  def attachCertificateToDistribution(request: model.AttachCertificateToDistributionRequest): ZIO[Lightsail, AwsError, model.AttachCertificateToDistributionResponse.ReadOnly] = ZIO.accessM(_.get.attachCertificateToDistribution(request))
  def deleteCertificate(request: model.DeleteCertificateRequest): ZIO[Lightsail, AwsError, model.DeleteCertificateResponse.ReadOnly] = ZIO.accessM(_.get.deleteCertificate(request))
  def getInstance(request: model.GetInstanceRequest): ZIO[Lightsail, AwsError, model.GetInstanceResponse.ReadOnly] = ZIO.accessM(_.get.getInstance(request))
  def getDistributions(request: model.GetDistributionsRequest): ZIO[Lightsail, AwsError, model.GetDistributionsResponse.ReadOnly] = ZIO.accessM(_.get.getDistributions(request))
  def getRelationalDatabases(request: model.GetRelationalDatabasesRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabasesResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabases(request))
  def attachLoadBalancerTlsCertificate(request: model.AttachLoadBalancerTlsCertificateRequest): ZIO[Lightsail, AwsError, model.AttachLoadBalancerTlsCertificateResponse.ReadOnly] = ZIO.accessM(_.get.attachLoadBalancerTlsCertificate(request))
  def getOperationsForResource(request: model.GetOperationsForResourceRequest): ZIO[Lightsail, AwsError, model.GetOperationsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.getOperationsForResource(request))
  def createDiskFromSnapshot(request: model.CreateDiskFromSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateDiskFromSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createDiskFromSnapshot(request))
  def getLoadBalancer(request: model.GetLoadBalancerRequest): ZIO[Lightsail, AwsError, model.GetLoadBalancerResponse.ReadOnly] = ZIO.accessM(_.get.getLoadBalancer(request))
  def deleteInstanceSnapshot(request: model.DeleteInstanceSnapshotRequest): ZIO[Lightsail, AwsError, model.DeleteInstanceSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteInstanceSnapshot(request))
  def deleteDomainEntry(request: model.DeleteDomainEntryRequest): ZIO[Lightsail, AwsError, model.DeleteDomainEntryResponse.ReadOnly] = ZIO.accessM(_.get.deleteDomainEntry(request))
  def updateRelationalDatabase(request: model.UpdateRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.UpdateRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.updateRelationalDatabase(request))
  def peerVpc(request: model.PeerVpcRequest): ZIO[Lightsail, AwsError, model.PeerVpcResponse.ReadOnly] = ZIO.accessM(_.get.peerVpc(request))
  def unpeerVpc(request: model.UnpeerVpcRequest): ZIO[Lightsail, AwsError, model.UnpeerVpcResponse.ReadOnly] = ZIO.accessM(_.get.unpeerVpc(request))
  def getActiveNames(request: model.GetActiveNamesRequest): ZIO[Lightsail, AwsError, model.GetActiveNamesResponse.ReadOnly] = ZIO.accessM(_.get.getActiveNames(request))
  def getAutoSnapshots(request: model.GetAutoSnapshotsRequest): ZIO[Lightsail, AwsError, model.GetAutoSnapshotsResponse.ReadOnly] = ZIO.accessM(_.get.getAutoSnapshots(request))
  def startRelationalDatabase(request: model.StartRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.StartRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.startRelationalDatabase(request))
  def createInstanceSnapshot(request: model.CreateInstanceSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateInstanceSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createInstanceSnapshot(request))
  def updateDomainEntry(request: model.UpdateDomainEntryRequest): ZIO[Lightsail, AwsError, model.UpdateDomainEntryResponse.ReadOnly] = ZIO.accessM(_.get.updateDomainEntry(request))
  def rebootInstance(request: model.RebootInstanceRequest): ZIO[Lightsail, AwsError, model.RebootInstanceResponse.ReadOnly] = ZIO.accessM(_.get.rebootInstance(request))
  def createContactMethod(request: model.CreateContactMethodRequest): ZIO[Lightsail, AwsError, model.CreateContactMethodResponse.ReadOnly] = ZIO.accessM(_.get.createContactMethod(request))
  def getDiskSnapshots(request: model.GetDiskSnapshotsRequest): ZIO[Lightsail, AwsError, model.GetDiskSnapshotsResponse.ReadOnly] = ZIO.accessM(_.get.getDiskSnapshots(request))
  def getContainerLog(request: model.GetContainerLogRequest): ZIO[Lightsail, AwsError, model.GetContainerLogResponse.ReadOnly] = ZIO.accessM(_.get.getContainerLog(request))
  def getContainerServiceDeployments(request: model.GetContainerServiceDeploymentsRequest): ZIO[Lightsail, AwsError, model.GetContainerServiceDeploymentsResponse.ReadOnly] = ZIO.accessM(_.get.getContainerServiceDeployments(request))
  def createDomain(request: model.CreateDomainRequest): ZIO[Lightsail, AwsError, model.CreateDomainResponse.ReadOnly] = ZIO.accessM(_.get.createDomain(request))
  def createContainerService(request: model.CreateContainerServiceRequest): ZIO[Lightsail, AwsError, model.CreateContainerServiceResponse.ReadOnly] = ZIO.accessM(_.get.createContainerService(request))
  def isVpcPeered(request: model.IsVpcPeeredRequest): ZIO[Lightsail, AwsError, model.IsVpcPeeredResponse.ReadOnly] = ZIO.accessM(_.get.isVpcPeered(request))
  def deleteAutoSnapshot(request: model.DeleteAutoSnapshotRequest): ZIO[Lightsail, AwsError, model.DeleteAutoSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteAutoSnapshot(request))
  def createContainerServiceRegistryLogin(request: model.CreateContainerServiceRegistryLoginRequest): ZIO[Lightsail, AwsError, model.CreateContainerServiceRegistryLoginResponse.ReadOnly] = ZIO.accessM(_.get.createContainerServiceRegistryLogin(request))
  def getDisk(request: model.GetDiskRequest): ZIO[Lightsail, AwsError, model.GetDiskResponse.ReadOnly] = ZIO.accessM(_.get.getDisk(request))
  def enableAddOn(request: model.EnableAddOnRequest): ZIO[Lightsail, AwsError, model.EnableAddOnResponse.ReadOnly] = ZIO.accessM(_.get.enableAddOn(request))
  def untagResource(request: model.UntagResourceRequest): ZIO[Lightsail, AwsError, model.UntagResourceResponse.ReadOnly] = ZIO.accessM(_.get.untagResource(request))
  def createLoadBalancerTlsCertificate(request: model.CreateLoadBalancerTlsCertificateRequest): ZIO[Lightsail, AwsError, model.CreateLoadBalancerTlsCertificateResponse.ReadOnly] = ZIO.accessM(_.get.createLoadBalancerTlsCertificate(request))
  def getStaticIp(request: model.GetStaticIpRequest): ZIO[Lightsail, AwsError, model.GetStaticIpResponse.ReadOnly] = ZIO.accessM(_.get.getStaticIp(request))
  def attachStaticIp(request: model.AttachStaticIpRequest): ZIO[Lightsail, AwsError, model.AttachStaticIpResponse.ReadOnly] = ZIO.accessM(_.get.attachStaticIp(request))
  def importKeyPair(request: model.ImportKeyPairRequest): ZIO[Lightsail, AwsError, model.ImportKeyPairResponse.ReadOnly] = ZIO.accessM(_.get.importKeyPair(request))
  def getDisks(request: model.GetDisksRequest): ZIO[Lightsail, AwsError, model.GetDisksResponse.ReadOnly] = ZIO.accessM(_.get.getDisks(request))
  def downloadDefaultKeyPair(request: model.DownloadDefaultKeyPairRequest): ZIO[Lightsail, AwsError, model.DownloadDefaultKeyPairResponse.ReadOnly] = ZIO.accessM(_.get.downloadDefaultKeyPair(request))
  def getExportSnapshotRecords(request: model.GetExportSnapshotRecordsRequest): ZIO[Lightsail, AwsError, model.GetExportSnapshotRecordsResponse.ReadOnly] = ZIO.accessM(_.get.getExportSnapshotRecords(request))
  def createKeyPair(request: model.CreateKeyPairRequest): ZIO[Lightsail, AwsError, model.CreateKeyPairResponse.ReadOnly] = ZIO.accessM(_.get.createKeyPair(request))
  def getBundles(request: model.GetBundlesRequest): ZIO[Lightsail, AwsError, model.GetBundlesResponse.ReadOnly] = ZIO.accessM(_.get.getBundles(request))
  def registerContainerImage(request: model.RegisterContainerImageRequest): ZIO[Lightsail, AwsError, model.RegisterContainerImageResponse.ReadOnly] = ZIO.accessM(_.get.registerContainerImage(request))
  def startInstance(request: model.StartInstanceRequest): ZIO[Lightsail, AwsError, model.StartInstanceResponse.ReadOnly] = ZIO.accessM(_.get.startInstance(request))
  def getInstancePortStates(request: model.GetInstancePortStatesRequest): ZIO[Lightsail, AwsError, model.GetInstancePortStatesResponse.ReadOnly] = ZIO.accessM(_.get.getInstancePortStates(request))
  def deleteDisk(request: model.DeleteDiskRequest): ZIO[Lightsail, AwsError, model.DeleteDiskResponse.ReadOnly] = ZIO.accessM(_.get.deleteDisk(request))
  def getBlueprints(request: model.GetBlueprintsRequest): ZIO[Lightsail, AwsError, model.GetBlueprintsResponse.ReadOnly] = ZIO.accessM(_.get.getBlueprints(request))
  def deleteAlarm(request: model.DeleteAlarmRequest): ZIO[Lightsail, AwsError, model.DeleteAlarmResponse.ReadOnly] = ZIO.accessM(_.get.deleteAlarm(request))
  def createRelationalDatabaseSnapshot(request: model.CreateRelationalDatabaseSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateRelationalDatabaseSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createRelationalDatabaseSnapshot(request))
  def getContainerServiceMetricData(request: model.GetContainerServiceMetricDataRequest): ZIO[Lightsail, AwsError, model.GetContainerServiceMetricDataResponse.ReadOnly] = ZIO.accessM(_.get.getContainerServiceMetricData(request))
  def getRelationalDatabaseLogStreams(request: model.GetRelationalDatabaseLogStreamsRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseLogStreamsResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseLogStreams(request))
  def updateRelationalDatabaseParameters(request: model.UpdateRelationalDatabaseParametersRequest): ZIO[Lightsail, AwsError, model.UpdateRelationalDatabaseParametersResponse.ReadOnly] = ZIO.accessM(_.get.updateRelationalDatabaseParameters(request))
  def createContainerServiceDeployment(request: model.CreateContainerServiceDeploymentRequest): ZIO[Lightsail, AwsError, model.CreateContainerServiceDeploymentResponse.ReadOnly] = ZIO.accessM(_.get.createContainerServiceDeployment(request))
  def getDistributionLatestCacheReset(request: model.GetDistributionLatestCacheResetRequest): ZIO[Lightsail, AwsError, model.GetDistributionLatestCacheResetResponse.ReadOnly] = ZIO.accessM(_.get.getDistributionLatestCacheReset(request))
  def updateDistributionBundle(request: model.UpdateDistributionBundleRequest): ZIO[Lightsail, AwsError, model.UpdateDistributionBundleResponse.ReadOnly] = ZIO.accessM(_.get.updateDistributionBundle(request))
  def deleteKeyPair(request: model.DeleteKeyPairRequest): ZIO[Lightsail, AwsError, model.DeleteKeyPairResponse.ReadOnly] = ZIO.accessM(_.get.deleteKeyPair(request))
  def getStaticIps(request: model.GetStaticIpsRequest): ZIO[Lightsail, AwsError, model.GetStaticIpsResponse.ReadOnly] = ZIO.accessM(_.get.getStaticIps(request))
  def createRelationalDatabase(request: model.CreateRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.CreateRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.createRelationalDatabase(request))
  def getCertificates(request: model.GetCertificatesRequest): ZIO[Lightsail, AwsError, model.GetCertificatesResponse.ReadOnly] = ZIO.accessM(_.get.getCertificates(request))
  def tagResource(request: model.TagResourceRequest): ZIO[Lightsail, AwsError, model.TagResourceResponse.ReadOnly] = ZIO.accessM(_.get.tagResource(request))
  def deleteDomain(request: model.DeleteDomainRequest): ZIO[Lightsail, AwsError, model.DeleteDomainResponse.ReadOnly] = ZIO.accessM(_.get.deleteDomain(request))
  def getRelationalDatabaseSnapshots(request: model.GetRelationalDatabaseSnapshotsRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseSnapshotsResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseSnapshots(request))
  def createInstancesFromSnapshot(request: model.CreateInstancesFromSnapshotRequest): ZIO[Lightsail, AwsError, model.CreateInstancesFromSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createInstancesFromSnapshot(request))
  def exportSnapshot(request: model.ExportSnapshotRequest): ZIO[Lightsail, AwsError, model.ExportSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.exportSnapshot(request))
  def attachDisk(request: model.AttachDiskRequest): ZIO[Lightsail, AwsError, model.AttachDiskResponse.ReadOnly] = ZIO.accessM(_.get.attachDisk(request))
  def setIpAddressType(request: model.SetIpAddressTypeRequest): ZIO[Lightsail, AwsError, model.SetIpAddressTypeResponse.ReadOnly] = ZIO.accessM(_.get.setIpAddressType(request))
  def getRegions(request: model.GetRegionsRequest): ZIO[Lightsail, AwsError, model.GetRegionsResponse.ReadOnly] = ZIO.accessM(_.get.getRegions(request))
  def getRelationalDatabaseMetricData(request: model.GetRelationalDatabaseMetricDataRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseMetricDataResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseMetricData(request))
  def getOperation(request: model.GetOperationRequest): ZIO[Lightsail, AwsError, model.GetOperationResponse.ReadOnly] = ZIO.accessM(_.get.getOperation(request))
  def stopInstance(request: model.StopInstanceRequest): ZIO[Lightsail, AwsError, model.StopInstanceResponse.ReadOnly] = ZIO.accessM(_.get.stopInstance(request))
  def getDistributionMetricData(request: model.GetDistributionMetricDataRequest): ZIO[Lightsail, AwsError, model.GetDistributionMetricDataResponse.ReadOnly] = ZIO.accessM(_.get.getDistributionMetricData(request))
  def getKeyPairs(request: model.GetKeyPairsRequest): ZIO[Lightsail, AwsError, model.GetKeyPairsResponse.ReadOnly] = ZIO.accessM(_.get.getKeyPairs(request))
  def disableAddOn(request: model.DisableAddOnRequest): ZIO[Lightsail, AwsError, model.DisableAddOnResponse.ReadOnly] = ZIO.accessM(_.get.disableAddOn(request))
  def createInstances(request: model.CreateInstancesRequest): ZIO[Lightsail, AwsError, model.CreateInstancesResponse.ReadOnly] = ZIO.accessM(_.get.createInstances(request))
  def createLoadBalancer(request: model.CreateLoadBalancerRequest): ZIO[Lightsail, AwsError, model.CreateLoadBalancerResponse.ReadOnly] = ZIO.accessM(_.get.createLoadBalancer(request))
  def getRelationalDatabaseBlueprints(request: model.GetRelationalDatabaseBlueprintsRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseBlueprintsResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseBlueprints(request))
  def detachCertificateFromDistribution(request: model.DetachCertificateFromDistributionRequest): ZIO[Lightsail, AwsError, model.DetachCertificateFromDistributionResponse.ReadOnly] = ZIO.accessM(_.get.detachCertificateFromDistribution(request))
  def getRelationalDatabaseMasterUserPassword(request: model.GetRelationalDatabaseMasterUserPasswordRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabaseMasterUserPassword(request))
  def updateContainerService(request: model.UpdateContainerServiceRequest): ZIO[Lightsail, AwsError, model.UpdateContainerServiceResponse.ReadOnly] = ZIO.accessM(_.get.updateContainerService(request))
  def getContainerServicePowers(request: model.GetContainerServicePowersRequest): ZIO[Lightsail, AwsError, model.GetContainerServicePowersResponse.ReadOnly] = ZIO.accessM(_.get.getContainerServicePowers(request))
  def getRelationalDatabase(request: model.GetRelationalDatabaseRequest): ZIO[Lightsail, AwsError, model.GetRelationalDatabaseResponse.ReadOnly] = ZIO.accessM(_.get.getRelationalDatabase(request))
  def getCloudFormationStackRecords(request: model.GetCloudFormationStackRecordsRequest): ZIO[Lightsail, AwsError, model.GetCloudFormationStackRecordsResponse.ReadOnly] = ZIO.accessM(_.get.getCloudFormationStackRecords(request))
  def updateDistribution(request: model.UpdateDistributionRequest): ZIO[Lightsail, AwsError, model.UpdateDistributionResponse.ReadOnly] = ZIO.accessM(_.get.updateDistribution(request))
  def deleteDistribution(request: model.DeleteDistributionRequest): ZIO[Lightsail, AwsError, model.DeleteDistributionResponse.ReadOnly] = ZIO.accessM(_.get.deleteDistribution(request))
  def deleteContainerImage(request: model.DeleteContainerImageRequest): ZIO[Lightsail, AwsError, model.DeleteContainerImageResponse.ReadOnly] = ZIO.accessM(_.get.deleteContainerImage(request))
  def createDistribution(request: model.CreateDistributionRequest): ZIO[Lightsail, AwsError, model.CreateDistributionResponse.ReadOnly] = ZIO.accessM(_.get.createDistribution(request))
}