package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateContainerServiceRequest(serviceName: primitives.ContainerServiceName, power: scala.Option[ContainerServicePowerName] = None, scale: scala.Option[primitives.ContainerServiceScale] = None, isDisabled: scala.Option[Boolean] = None, publicDomainNames: scala.Option[Map[String, Iterable[String]]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest = {
    import UpdateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest.builder().serviceName(serviceName: java.lang.String).optionallyWith(power.map(value => value.unwrap))(_.power).optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale).optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(_.isDisabled).optionallyWith(publicDomainNames.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item: java.lang.String
        }.asJavaCollection
    }).asJava))(_.publicDomainNames).build()
  }
  def asReadOnly: UpdateContainerServiceRequest.ReadOnly = UpdateContainerServiceRequest.wrap(buildAwsValue())
}
object UpdateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateContainerServiceRequest = UpdateContainerServiceRequest(serviceNameValue, powerValue.map(value => value), scaleValue.map(value => value), isDisabledValue.map(value => value), publicDomainNamesValue.map(value => value))
    def serviceNameValue: primitives.ContainerServiceName
    def powerValue: scala.Option[ContainerServicePowerName]
    def scaleValue: scala.Option[primitives.ContainerServiceScale]
    def isDisabledValue: scala.Option[Boolean]
    def publicDomainNamesValue: scala.Option[Map[String, List[String]]]
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def power: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServicePowerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("power", powerValue)
    def scale: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ContainerServiceScale] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scale", scaleValue)
    def isDisabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isDisabled", isDisabledValue)
    def publicDomainNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, List[String]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest) extends UpdateContainerServiceRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def powerValue: scala.Option[ContainerServicePowerName] = scala.Option(impl.power()).map(value => ContainerServicePowerName.wrap(value))
    override def scaleValue: scala.Option[primitives.ContainerServiceScale] = scala.Option(impl.scale()).map(value => value: primitives.ContainerServiceScale)
    override def isDisabledValue: scala.Option[Boolean] = scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override def publicDomainNamesValue: scala.Option[Map[String, List[String]]] = scala.Option(impl.publicDomainNames()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> value.asScala.map { item => 
          item: String
        }.toList
    }).toMap)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest): ReadOnly = new Wrapper(impl)
}