package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Tag(key: scala.Option[primitives.TagKey] = None, value: scala.Option[primitives.TagValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Tag.builder().optionallyWith(key.map(value => value: java.lang.String))(_.key).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: Tag.ReadOnly = Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Tag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Tag = Tag(keyValue.map(value => value), valueValue.map(value => value))
    def keyValue: scala.Option[primitives.TagKey]
    def valueValue: scala.Option[primitives.TagValue]
    def key: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TagKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("key", keyValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TagValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Tag) extends Tag.ReadOnly {
    override def keyValue: scala.Option[primitives.TagKey] = scala.Option(impl.key()).map(value => value: primitives.TagKey)
    override def valueValue: scala.Option[primitives.TagValue] = scala.Option(impl.value()).map(value => value: primitives.TagValue)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Tag): ReadOnly = new Wrapper(impl)
}