package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StartInstanceRequest(instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StartInstanceRequest = {
    import StartInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartInstanceRequest.builder().instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: StartInstanceRequest.ReadOnly = StartInstanceRequest.wrap(buildAwsValue())
}
object StartInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StartInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StartInstanceRequest = StartInstanceRequest(instanceNameValue)
    def instanceNameValue: primitives.ResourceName
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest) extends StartInstanceRequest.ReadOnly { override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest): ReadOnly = new Wrapper(impl)
}