package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait MetricUnit { def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit }
object MetricUnit {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.MetricUnit): MetricUnit = value match {
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MICROSECONDS =>
      val r = Microseconds
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MILLISECONDS =>
      val r = Milliseconds
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.BYTES =>
      val r = Bytes
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBYTES =>
      val r = Kilobytes
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABYTES =>
      val r = Megabytes
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABYTES =>
      val r = Gigabytes
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABYTES =>
      val r = Terabytes
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.BITS =>
      val r = Bits
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBITS =>
      val r = Kilobits
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABITS =>
      val r = Megabits
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABITS =>
      val r = Gigabits
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABITS =>
      val r = Terabits
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.PERCENT =>
      val r = Percent
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.COUNT =>
      val r = Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.BYTES_SECOND =>
      val r = `Bytes/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBYTES_SECOND =>
      val r = `Kilobytes/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABYTES_SECOND =>
      val r = `Megabytes/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABYTES_SECOND =>
      val r = `Gigabytes/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABYTES_SECOND =>
      val r = `Terabytes/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.BITS_SECOND =>
      val r = `Bits/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBITS_SECOND =>
      val r = `Kilobits/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABITS_SECOND =>
      val r = `Megabits/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABITS_SECOND =>
      val r = `Gigabits/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABITS_SECOND =>
      val r = `Terabits/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.COUNT_SECOND =>
      val r = `Count/Second`
      r
    case software.amazon.awssdk.services.lightsail.model.MetricUnit.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.UNKNOWN_TO_SDK_VERSION }
  case object Seconds extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.SECONDS }
  case object Microseconds extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MICROSECONDS }
  case object Milliseconds extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MILLISECONDS }
  case object Bytes extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.BYTES }
  case object Kilobytes extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBYTES }
  case object Megabytes extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABYTES }
  case object Gigabytes extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABYTES }
  case object Terabytes extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABYTES }
  case object Bits extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.BITS }
  case object Kilobits extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBITS }
  case object Megabits extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABITS }
  case object Gigabits extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABITS }
  case object Terabits extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABITS }
  case object Percent extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.PERCENT }
  case object Count extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.COUNT }
  case object `Bytes/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.BYTES_SECOND }
  case object `Kilobytes/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBYTES_SECOND }
  case object `Megabytes/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABYTES_SECOND }
  case object `Gigabytes/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABYTES_SECOND }
  case object `Terabytes/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABYTES_SECOND }
  case object `Bits/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.BITS_SECOND }
  case object `Kilobits/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.KILOBITS_SECOND }
  case object `Megabits/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.MEGABITS_SECOND }
  case object `Gigabits/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.GIGABITS_SECOND }
  case object `Terabits/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.TERABITS_SECOND }
  case object `Count/Second` extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.COUNT_SECOND }
  case object None extends MetricUnit { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricUnit = software.amazon.awssdk.services.lightsail.model.MetricUnit.NONE }
}