package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait MetricStatistic { def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic }
object MetricStatistic {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.MetricStatistic): MetricStatistic = value match {
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
  }
  case object unknownToSdkVersion extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION }
  case object Minimum extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.MINIMUM }
  case object Maximum extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.MAXIMUM }
  case object Sum extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.SUM }
  case object Average extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.AVERAGE }
  case object SampleCount extends MetricStatistic { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic = software.amazon.awssdk.services.lightsail.model.MetricStatistic.SAMPLE_COUNT }
}