package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerState { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState }
object LoadBalancerState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerState): LoadBalancerState = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.PROVISIONING =>
      val r = provisioning
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE_IMPAIRED =>
      val r = active_impaired
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN_TO_SDK_VERSION }
  case object active extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE }
  case object provisioning extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.PROVISIONING }
  case object active_impaired extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE_IMPAIRED }
  case object failed extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.FAILED }
  case object unknown extends LoadBalancerState { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState = software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN }
}