package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceState(code: scala.Option[primitives.Integer] = None, name: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceState.builder().optionallyWith(code.map(value => value: java.lang.Integer))(_.code).optionallyWith(name.map(value => value: java.lang.String))(_.name).build()
  }
  def asReadOnly: InstanceState.ReadOnly = InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceState] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceState = InstanceState(codeValue.map(value => value), nameValue.map(value => value))
    def codeValue: scala.Option[primitives.Integer]
    def nameValue: scala.Option[String]
    def code: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("code", codeValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceState) extends InstanceState.ReadOnly {
    override def codeValue: scala.Option[primitives.Integer] = scala.Option(impl.code()).map(value => value: primitives.Integer)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceState): ReadOnly = new Wrapper(impl)
}