package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait InstanceSnapshotState { def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState }
object InstanceSnapshotState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState): InstanceSnapshotState = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.AVAILABLE =>
      val r = available
      r
  }
  case object unknownToSdkVersion extends InstanceSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState = software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.UNKNOWN_TO_SDK_VERSION }
  case object pending extends InstanceSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState = software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.PENDING }
  case object error extends InstanceSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState = software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.ERROR }
  case object available extends InstanceSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState = software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState.AVAILABLE }
}