package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class HeaderObject(option: scala.Option[ForwardValues] = None, headersAllowList: scala.Option[Iterable[HeaderEnum]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.HeaderObject = {
    import HeaderObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HeaderObject.builder().optionallyWith(option.map(value => value.unwrap))(_.option).optionallyWith(headersAllowList.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.headersAllowListWithStrings).build()
  }
  def asReadOnly: HeaderObject.ReadOnly = HeaderObject.wrap(buildAwsValue())
}
object HeaderObject {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.HeaderObject] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: HeaderObject = HeaderObject(optionValue.map(value => value), headersAllowListValue.map(value => value))
    def optionValue: scala.Option[ForwardValues]
    def headersAllowListValue: scala.Option[List[HeaderEnum]]
    def option: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ForwardValues] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("option", optionValue)
    def headersAllowList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[HeaderEnum]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("headersAllowList", headersAllowListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.HeaderObject) extends HeaderObject.ReadOnly {
    override def optionValue: scala.Option[ForwardValues] = scala.Option(impl.option()).map(value => ForwardValues.wrap(value))
    override def headersAllowListValue: scala.Option[List[HeaderEnum]] = scala.Option(impl.headersAllowList()).map(value => value.asScala.map { item => 
      HeaderEnum.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.HeaderObject): ReadOnly = new Wrapper(impl)
}