package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseMetricDataRequest(relationalDatabaseName: primitives.ResourceName, metricName: RelationalDatabaseMetricName, period: primitives.MetricPeriod, startTime: primitives.IsoDate, endTime: primitives.IsoDate, unit: MetricUnit, statistics: Iterable[MetricStatistic]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = {
    import GetRelationalDatabaseMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).metricName(metricName.unwrap).period(period: java.lang.Integer).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).unit(unit.unwrap).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: GetRelationalDatabaseMetricDataRequest.ReadOnly = GetRelationalDatabaseMetricDataRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseMetricDataRequest = GetRelationalDatabaseMetricDataRequest(relationalDatabaseNameValue, metricNameValue, periodValue, startTimeValue, endTimeValue, unitValue, statisticsValue)
    def relationalDatabaseNameValue: primitives.ResourceName
    def metricNameValue: RelationalDatabaseMetricName
    def periodValue: primitives.MetricPeriod
    def startTimeValue: primitives.IsoDate
    def endTimeValue: primitives.IsoDate
    def unitValue: MetricUnit
    def statisticsValue: List[MetricStatistic]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def metricName: ZIO[Any, Nothing, RelationalDatabaseMetricName] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(endTimeValue)
    def unit: ZIO[Any, Nothing, MetricUnit] = ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest) extends GetRelationalDatabaseMetricDataRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def metricNameValue: RelationalDatabaseMetricName = RelationalDatabaseMetricName.wrap(impl.metricName())
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def startTimeValue: primitives.IsoDate = impl.startTime(): primitives.IsoDate
    override def endTimeValue: primitives.IsoDate = impl.endTime(): primitives.IsoDate
    override def unitValue: MetricUnit = MetricUnit.wrap(impl.unit())
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest): ReadOnly = new Wrapper(impl)
}