package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRegionsResponse(regions: scala.Option[Iterable[Region]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRegionsResponse = {
    import GetRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsResponse.builder().optionallyWith(regions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.regions).build()
  }
  def asReadOnly: GetRegionsResponse.ReadOnly = GetRegionsResponse.wrap(buildAwsValue())
}
object GetRegionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRegionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRegionsResponse = GetRegionsResponse(regionsValue.map(value => value.map { item => 
      item.editable
    }))
    def regionsValue: scala.Option[List[Region.ReadOnly]]
    def regions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Region.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("regions", regionsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse) extends GetRegionsResponse.ReadOnly {
    override def regionsValue: scala.Option[List[Region.ReadOnly]] = scala.Option(impl.regions()).map(value => value.asScala.map { item => 
      Region.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse): ReadOnly = new Wrapper(impl)
}