package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerMetricDataRequest(loadBalancerName: primitives.ResourceName, metricName: LoadBalancerMetricName, period: primitives.MetricPeriod, startTime: primitives.Timestamp, endTime: primitives.Timestamp, unit: MetricUnit, statistics: Iterable[MetricStatistic]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest = {
    import GetLoadBalancerMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).metricName(metricName.unwrap).period(period: java.lang.Integer).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).unit(unit.unwrap).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: GetLoadBalancerMetricDataRequest.ReadOnly = GetLoadBalancerMetricDataRequest.wrap(buildAwsValue())
}
object GetLoadBalancerMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerMetricDataRequest = GetLoadBalancerMetricDataRequest(loadBalancerNameValue, metricNameValue, periodValue, startTimeValue, endTimeValue, unitValue, statisticsValue)
    def loadBalancerNameValue: primitives.ResourceName
    def metricNameValue: LoadBalancerMetricName
    def periodValue: primitives.MetricPeriod
    def startTimeValue: primitives.Timestamp
    def endTimeValue: primitives.Timestamp
    def unitValue: MetricUnit
    def statisticsValue: List[MetricStatistic]
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def metricName: ZIO[Any, Nothing, LoadBalancerMetricName] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(endTimeValue)
    def unit: ZIO[Any, Nothing, MetricUnit] = ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest) extends GetLoadBalancerMetricDataRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def metricNameValue: LoadBalancerMetricName = LoadBalancerMetricName.wrap(impl.metricName())
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def startTimeValue: primitives.Timestamp = impl.startTime(): primitives.Timestamp
    override def endTimeValue: primitives.Timestamp = impl.endTime(): primitives.Timestamp
    override def unitValue: MetricUnit = MetricUnit.wrap(impl.unit())
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest): ReadOnly = new Wrapper(impl)
}