package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetKeyPairResponse(keyPair: scala.Option[KeyPair] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse = {
    import GetKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse.builder().optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair).build()
  }
  def asReadOnly: GetKeyPairResponse.ReadOnly = GetKeyPairResponse.wrap(buildAwsValue())
}
object GetKeyPairResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetKeyPairResponse = GetKeyPairResponse(keyPairValue.map(value => value.editable))
    def keyPairValue: scala.Option[KeyPair.ReadOnly]
    def keyPair: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KeyPair.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPair", keyPairValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse) extends GetKeyPairResponse.ReadOnly { override def keyPairValue: scala.Option[KeyPair.ReadOnly] = scala.Option(impl.keyPair()).map(value => KeyPair.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse): ReadOnly = new Wrapper(impl)
}