package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetExportSnapshotRecordsResponse(exportSnapshotRecords: scala.Option[Iterable[ExportSnapshotRecord]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse = {
    import GetExportSnapshotRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse.builder().optionallyWith(exportSnapshotRecords.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.exportSnapshotRecords).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetExportSnapshotRecordsResponse.ReadOnly = GetExportSnapshotRecordsResponse.wrap(buildAwsValue())
}
object GetExportSnapshotRecordsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetExportSnapshotRecordsResponse = GetExportSnapshotRecordsResponse(exportSnapshotRecordsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def exportSnapshotRecordsValue: scala.Option[List[ExportSnapshotRecord.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def exportSnapshotRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ExportSnapshotRecord.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportSnapshotRecords", exportSnapshotRecordsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse) extends GetExportSnapshotRecordsResponse.ReadOnly {
    override def exportSnapshotRecordsValue: scala.Option[List[ExportSnapshotRecord.ReadOnly]] = scala.Option(impl.exportSnapshotRecords()).map(value => value.asScala.map { item => 
      ExportSnapshotRecord.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse): ReadOnly = new Wrapper(impl)
}