package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDomainRequest(domainName: primitives.DomainName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDomainRequest = {
    import GetDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainRequest.builder().domainName(domainName: java.lang.String).build()
  }
  def asReadOnly: GetDomainRequest.ReadOnly = GetDomainRequest.wrap(buildAwsValue())
}
object GetDomainRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDomainRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDomainRequest = GetDomainRequest(domainNameValue)
    def domainNameValue: primitives.DomainName
    def domainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(domainNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest) extends GetDomainRequest.ReadOnly { override def domainNameValue: primitives.DomainName = impl.domainName(): primitives.DomainName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest): ReadOnly = new Wrapper(impl)
}