package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDiskSnapshotResponse(diskSnapshot: scala.Option[DiskSnapshot] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse = {
    import GetDiskSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse.builder().optionallyWith(diskSnapshot.map(value => value.buildAwsValue()))(_.diskSnapshot).build()
  }
  def asReadOnly: GetDiskSnapshotResponse.ReadOnly = GetDiskSnapshotResponse.wrap(buildAwsValue())
}
object GetDiskSnapshotResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDiskSnapshotResponse = GetDiskSnapshotResponse(diskSnapshotValue.map(value => value.editable))
    def diskSnapshotValue: scala.Option[DiskSnapshot.ReadOnly]
    def diskSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DiskSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSnapshot", diskSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse) extends GetDiskSnapshotResponse.ReadOnly { override def diskSnapshotValue: scala.Option[DiskSnapshot.ReadOnly] = scala.Option(impl.diskSnapshot()).map(value => DiskSnapshot.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse): ReadOnly = new Wrapper(impl)
}