package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDiskSnapshotRequest(diskSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest = {
    import GetDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest.builder().diskSnapshotName(diskSnapshotName: java.lang.String).build()
  }
  def asReadOnly: GetDiskSnapshotRequest.ReadOnly = GetDiskSnapshotRequest.wrap(buildAwsValue())
}
object GetDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDiskSnapshotRequest = GetDiskSnapshotRequest(diskSnapshotNameValue)
    def diskSnapshotNameValue: primitives.ResourceName
    def diskSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest) extends GetDiskSnapshotRequest.ReadOnly { override def diskSnapshotNameValue: primitives.ResourceName = impl.diskSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest): ReadOnly = new Wrapper(impl)
}