package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBundlesRequest(includeInactive: scala.Option[Boolean] = None, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBundlesRequest = {
    import GetBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest.builder().optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(_.includeInactive).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetBundlesRequest.ReadOnly = GetBundlesRequest.wrap(buildAwsValue())
}
object GetBundlesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBundlesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBundlesRequest = GetBundlesRequest(includeInactiveValue.map(value => value), pageTokenValue.map(value => value))
    def includeInactiveValue: scala.Option[Boolean]
    def pageTokenValue: scala.Option[String]
    def includeInactive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeInactive", includeInactiveValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest) extends GetBundlesRequest.ReadOnly {
    override def includeInactiveValue: scala.Option[Boolean] = scala.Option(impl.includeInactive()).map(value => value: Boolean)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest): ReadOnly = new Wrapper(impl)
}