package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait DiskSnapshotState { def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState }
object DiskSnapshotState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState): DiskSnapshotState = value match {
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.COMPLETED =>
      val r = completed
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion extends DiskSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState = software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN_TO_SDK_VERSION }
  case object pending extends DiskSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState = software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.PENDING }
  case object completed extends DiskSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState = software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.COMPLETED }
  case object error extends DiskSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState = software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.ERROR }
  case object unknown extends DiskSnapshotState { override def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState = software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN }
}