package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiskSnapshot(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, sizeInGb: scala.Option[primitives.Integer] = None, state: scala.Option[DiskSnapshotState] = None, progress: scala.Option[String] = None, fromDiskName: scala.Option[primitives.ResourceName] = None, fromDiskArn: scala.Option[primitives.NonEmptyString] = None, fromInstanceName: scala.Option[primitives.ResourceName] = None, fromInstanceArn: scala.Option[primitives.NonEmptyString] = None, isFromAutoSnapshot: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DiskSnapshot = {
    import DiskSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshot.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(progress.map(value => value: java.lang.String))(_.progress).optionallyWith(fromDiskName.map(value => value: java.lang.String))(_.fromDiskName).optionallyWith(fromDiskArn.map(value => value: java.lang.String))(_.fromDiskArn).optionallyWith(fromInstanceName.map(value => value: java.lang.String))(_.fromInstanceName).optionallyWith(fromInstanceArn.map(value => value: java.lang.String))(_.fromInstanceArn).optionallyWith(isFromAutoSnapshot.map(value => value: java.lang.Boolean))(_.isFromAutoSnapshot).build()
  }
  def asReadOnly: DiskSnapshot.ReadOnly = DiskSnapshot.wrap(buildAwsValue())
}
object DiskSnapshot {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiskSnapshot = DiskSnapshot(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), sizeInGbValue.map(value => value), stateValue.map(value => value), progressValue.map(value => value), fromDiskNameValue.map(value => value), fromDiskArnValue.map(value => value), fromInstanceNameValue.map(value => value), fromInstanceArnValue.map(value => value), isFromAutoSnapshotValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def stateValue: scala.Option[DiskSnapshotState]
    def progressValue: scala.Option[String]
    def fromDiskNameValue: scala.Option[primitives.ResourceName]
    def fromDiskArnValue: scala.Option[primitives.NonEmptyString]
    def fromInstanceNameValue: scala.Option[primitives.ResourceName]
    def fromInstanceArnValue: scala.Option[primitives.NonEmptyString]
    def isFromAutoSnapshotValue: scala.Option[Boolean]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DiskSnapshotState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def progress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("progress", progressValue)
    def fromDiskName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromDiskName", fromDiskNameValue)
    def fromDiskArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromDiskArn", fromDiskArnValue)
    def fromInstanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromInstanceName", fromInstanceNameValue)
    def fromInstanceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArnValue)
    def isFromAutoSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot) extends DiskSnapshot.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
    override def stateValue: scala.Option[DiskSnapshotState] = scala.Option(impl.state()).map(value => DiskSnapshotState.wrap(value))
    override def progressValue: scala.Option[String] = scala.Option(impl.progress()).map(value => value: String)
    override def fromDiskNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.fromDiskName()).map(value => value: primitives.ResourceName)
    override def fromDiskArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromDiskArn()).map(value => value: primitives.NonEmptyString)
    override def fromInstanceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.fromInstanceName()).map(value => value: primitives.ResourceName)
    override def fromInstanceArnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.fromInstanceArn()).map(value => value: primitives.NonEmptyString)
    override def isFromAutoSnapshotValue: scala.Option[Boolean] = scala.Option(impl.isFromAutoSnapshot()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot): ReadOnly = new Wrapper(impl)
}