package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName, skipFinalSnapshot: scala.Option[Boolean] = None, finalRelationalDatabaseSnapshotName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest = {
    import DeleteRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(_.skipFinalSnapshot).optionallyWith(finalRelationalDatabaseSnapshotName.map(value => value: java.lang.String))(_.finalRelationalDatabaseSnapshotName).build()
  }
  def asReadOnly: DeleteRelationalDatabaseRequest.ReadOnly = DeleteRelationalDatabaseRequest.wrap(buildAwsValue())
}
object DeleteRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteRelationalDatabaseRequest = DeleteRelationalDatabaseRequest(relationalDatabaseNameValue, skipFinalSnapshotValue.map(value => value), finalRelationalDatabaseSnapshotNameValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def skipFinalSnapshotValue: scala.Option[Boolean]
    def finalRelationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def skipFinalSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshotValue)
    def finalRelationalDatabaseSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("finalRelationalDatabaseSnapshotName", finalRelationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest) extends DeleteRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def skipFinalSnapshotValue: scala.Option[Boolean] = scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override def finalRelationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.finalRelationalDatabaseSnapshotName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}