package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteContactMethodRequest(protocol: ContactProtocol) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest = {
    import DeleteContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest.builder().protocol(protocol.unwrap).build()
  }
  def asReadOnly: DeleteContactMethodRequest.ReadOnly = DeleteContactMethodRequest.wrap(buildAwsValue())
}
object DeleteContactMethodRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteContactMethodRequest = DeleteContactMethodRequest(protocolValue)
    def protocolValue: ContactProtocol
    def protocol: ZIO[Any, Nothing, ContactProtocol] = ZIO.succeed(protocolValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest) extends DeleteContactMethodRequest.ReadOnly { override def protocolValue: ContactProtocol = ContactProtocol.wrap(impl.protocol()) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest): ReadOnly = new Wrapper(impl)
}