package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceRegistryLogin(username: scala.Option[String] = None, password: scala.Option[String] = None, expiresAt: scala.Option[primitives.IsoDate] = None, registry: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin = {
    import ContainerServiceRegistryLogin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin.builder().optionallyWith(username.map(value => value: java.lang.String))(_.username).optionallyWith(password.map(value => value: java.lang.String))(_.password).optionallyWith(expiresAt.map(value => value: java.time.Instant))(_.expiresAt).optionallyWith(registry.map(value => value: java.lang.String))(_.registry).build()
  }
  def asReadOnly: ContainerServiceRegistryLogin.ReadOnly = ContainerServiceRegistryLogin.wrap(buildAwsValue())
}
object ContainerServiceRegistryLogin {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceRegistryLogin = ContainerServiceRegistryLogin(usernameValue.map(value => value), passwordValue.map(value => value), expiresAtValue.map(value => value), registryValue.map(value => value))
    def usernameValue: scala.Option[String]
    def passwordValue: scala.Option[String]
    def expiresAtValue: scala.Option[primitives.IsoDate]
    def registryValue: scala.Option[String]
    def username: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("username", usernameValue)
    def password: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("password", passwordValue)
    def expiresAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiresAt", expiresAtValue)
    def registry: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("registry", registryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin) extends ContainerServiceRegistryLogin.ReadOnly {
    override def usernameValue: scala.Option[String] = scala.Option(impl.username()).map(value => value: String)
    override def passwordValue: scala.Option[String] = scala.Option(impl.password()).map(value => value: String)
    override def expiresAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.expiresAt()).map(value => value: primitives.IsoDate)
    override def registryValue: scala.Option[String] = scala.Option(impl.registry()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceRegistryLogin): ReadOnly = new Wrapper(impl)
}