package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TestAlarmRequest(alarmName: primitives.ResourceName, state: AlarmState) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.TestAlarmRequest = {
    import TestAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TestAlarmRequest.builder().alarmName(alarmName: java.lang.String).state(state.unwrap).build()
  }
  def asReadOnly: TestAlarmRequest.ReadOnly = TestAlarmRequest.wrap(buildAwsValue())
}
object TestAlarmRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.TestAlarmRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TestAlarmRequest = TestAlarmRequest(alarmNameValue, stateValue)
    def alarmNameValue: primitives.ResourceName
    def stateValue: AlarmState
    def alarmName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(alarmNameValue)
    def state: ZIO[Any, Nothing, AlarmState] = ZIO.succeed(stateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest) extends TestAlarmRequest.ReadOnly {
    override def alarmNameValue: primitives.ResourceName = impl.alarmName(): primitives.ResourceName
    override def stateValue: AlarmState = AlarmState.wrap(impl.state())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest): ReadOnly = new Wrapper(impl)
}