package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StopRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName, relationalDatabaseSnapshotName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest = {
    import StopRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(relationalDatabaseSnapshotName.map(value => value: java.lang.String))(_.relationalDatabaseSnapshotName).build()
  }
  def asReadOnly: StopRelationalDatabaseRequest.ReadOnly = StopRelationalDatabaseRequest.wrap(buildAwsValue())
}
object StopRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StopRelationalDatabaseRequest = StopRelationalDatabaseRequest(relationalDatabaseNameValue, relationalDatabaseSnapshotNameValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def relationalDatabaseSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseSnapshotName", relationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest) extends StopRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def relationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.relationalDatabaseSnapshotName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}