package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait PortInfoSourceType { def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType }
object PortInfoSourceType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType): PortInfoSourceType = value match {
    case software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.INSTANCE =>
      val r = INSTANCE
      r
    case software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion extends PortInfoSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType = software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.UNKNOWN_TO_SDK_VERSION }
  case object DEFAULT extends PortInfoSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType = software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.DEFAULT }
  case object INSTANCE extends PortInfoSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType = software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.INSTANCE }
  case object NONE extends PortInfoSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType = software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.NONE }
  case object CLOSED extends PortInfoSourceType { override def unwrap: software.amazon.awssdk.services.lightsail.model.PortInfoSourceType = software.amazon.awssdk.services.lightsail.model.PortInfoSourceType.CLOSED }
}