package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LogEvent(createdAt: scala.Option[primitives.IsoDate] = None, message: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LogEvent = {
    import LogEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LogEvent.builder().optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
  }
  def asReadOnly: LogEvent.ReadOnly = LogEvent.wrap(buildAwsValue())
}
object LogEvent {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LogEvent] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LogEvent = LogEvent(createdAtValue.map(value => value), messageValue.map(value => value))
    def createdAtValue: scala.Option[primitives.IsoDate]
    def messageValue: scala.Option[String]
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LogEvent) extends LogEvent.ReadOnly {
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LogEvent): ReadOnly = new Wrapper(impl)
}